"""Creates the project file directories needed required by the training and
analysis scripts.

Creates the parent folders "data", "models", and "analysis". Any experiment
script that is run must create a subfolder under the parent folders with the
name of the experiment. For example, if your experiment name is
"my_experiment", then you will have the following folder structure:
    - /data
        -- /my_experiment
    - /models
        -- /my_experiment
    - /analysis
        -- /my_experiment

The folder "data" stores any data generated by a script. The folder "models"
stores model checkpoints. The folder "analysis" stores the output of any
analysis that is performed (such as plots).

NOTE: Before running this script, please set the PROJECT_PATH variable to 
your chosen output directory in the user.py script.
"""

from env.directories import create_project_directory
from env.user import PROJECT_PATH

if __name__ == "__main__":
    create_project_directory(path=PROJECT_PATH)
