import torch
import random
import numpy as np

def seed_all(seed: int):
    """Seed all RNGs.
    
    For reproducibility, sets a fixed seeds for all RNGs.
    """
    torch.manual_seed(seed=seed)
    random.seed(seed)
    np.random.seed(seed=seed)
    
    if torch.cuda.is_available():
        torch.cuda.manual_seed(seed=seed)