%%%%%%% System Identification %%%%%%%%

clear, clc

Y = [[-0.50420,0.40391,0.20771,3.36970,19.26883
-0.50016,0.59399,0.24141,2.98114,19.53761
-0.49422,0.78559,0.27122,2.60000,19.76569
-0.48637,0.97832,0.29722,2.22635,19.95292
-0.47658,1.17180,0.31949,1.86002,20.09829
-0.46486,1.36573,0.33809,1.50065,20.20010
-0.45121,1.55979,0.35309,1.14774,20.25607
-0.43561,1.75369,0.36457,0.80076,20.26352
-0.41807,1.94710,0.37258,0.45913,20.21942
-0.39860,2.13970,0.37717,0.12231,20.12055
-0.37720,2.33112,0.37839,-0.21021,19.96360
-0.35389,2.52097,0.37629,-0.53884,19.74525
-0.32868,2.70882,0.37090,-0.86390,19.46233
-0.30160,2.89419,0.36226,-1.18557,19.11186
-0.27265,3.07658,0.35041,-1.50390,18.69123
-0.24189,3.25542,0.33537,-1.81875,18.19828
-0.20933,3.43013,0.31718,-2.12980,17.63139
-0.17503,3.60005,0.29588,-2.43655,16.98966
-0.13903,3.76450,0.27152,-2.73827,16.27292
-0.10139,3.92277,0.24413,-3.03403,15.48191
-0.06216,4.07412,0.21379,-3.32271,14.61824
-0.02142,4.21776,0.18057,-3.60298,13.68447
0.02076,4.35292,0.14454,-3.87336,12.68412
0.06429,4.47881,0.10580,-4.13224,11.62154
0.10908,4.59464,0.06448,-4.37796,10.50181
0.15502,4.69967,0.02070,-4.60880,9.33059
0.20202,4.79318,-0.02539,-4.82316,8.11386
0.24995,4.87451,-0.07362,-5.01953,6.85763
0.29870,4.94307,-0.12381,-5.19668,5.56767
0.34813,4.99835,-0.17578,-5.35363,4.24914
0.39811,5.03995,-0.22932,-5.48979,2.90634
0.44851,5.06754,-0.28421,-5.60497,1.54239
0.49919,5.08088,-0.34026,-5.69939,0.15907
0.54999,5.07983,-0.39726,-5.77372,-1.24338
0.60079,5.06429,-0.45499,-5.82901,-2.66627
0.65144,5.03424,-0.51328,-5.86668,-4.11253
0.70178,4.98965,-0.57195,-5.88843,-5.58663
0.75167,4.93051,-0.63084,-5.89619,-7.09455
0.80098,4.85676,-0.68980,-5.89209,-8.64373
0.84955,4.76832,-0.74872,-5.87837,-10.24301
]];

T = 0.01
Y = Y';
X = Y(1:4,:);
U = Y(5,:);

[~, N] = size(Y);

k = 20;
end_k = 28;
A_bar = X(:,k+1:end_k)*pinv(Y(:,k:end_k-1))

Ak = A_bar(:,1:4);
Bk = A_bar(:,5);

Ac = (Ak - eye(4))/T
Bc = Bk/T

% Learned A and B in discrete form
A = [[ 0.92711078 -0.05051037 -0.24976697 -0.04513857]
 [ 0.48957787  0.76168445 -0.2983266  -0.15023423]
 [-0.24815822 -0.20601327  0.14964478 -0.14367852]
 [-4.29590777  1.26525649  0.62681816  1.7208228 ]];
B = [[ 0.00994732]
 [ 0.04838145]
 [ 0.0338666 ]
 [-0.23426057]];

A = Ak;
B = Bk;

% 

x0 = [0.20202,4.79318,-0.02539,-4.82316]';
u0 = 8.11386;
x1 = A*x0 + B*u0

start_idx = 22;
end_idx = N-8;

P = [];
p = [X(:,start_idx); U(start_idx)]

P_size = N - start_idx;

for i = start_idx:end_idx-1
    x_new = [A B]*p;
    P = [P x_new];
    p = [x_new; U(i)];
end


figure
subplot(2,2,1)
plot([2:end_idx], X(1,2:end_idx), 'ko', 'LineWidth', 1);
hold on;
plot([start_idx+1:end_idx], P(1,:), 'r+', 'LineWidth', 1);
xlabel("N");
ylabel("x");
legend("actual", "predict", "Location","southwest");

subplot(2,2,2)
plot([2:end_idx], X(2,2:end_idx), 'ko', 'LineWidth', 1);
hold on;
plot([start_idx+1:end_idx], P(2,:), 'r+', 'LineWidth', 1);
xlabel("N");
ylabel("x_dot");
legend("actual", "predict", "Location","southwest");

subplot(2,2,3)
plot([2:end_idx], X(3,2:end_idx), 'ko', 'LineWidth', 1);
hold on;
plot([start_idx+1:end_idx], P(3,:), 'r+', 'LineWidth', 1);
xlabel("N");
ylabel("theta");
legend("actual", "predict", "Location","southwest");

subplot(2,2,4)
plot([2:end_idx], X(4,2:end_idx), 'ko', 'LineWidth', 1);
hold on;
plot([start_idx+1:end_idx], P(4,:), 'r+', 'LineWidth', 1);
xlabel("N");
ylabel("theta_dot");
legend("actual", "predict", "Location","southwest");
