clear;
clc;


T = 1/10;  %sampling period

C = [1, 0, 0];

%%%%Contiunous matrices%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
aA = [zeros(1,1),  zeros(1,3),           C,    zeros(1,3);
      zeros(3,1),  zeros(3,3),    zeros(3,3),        eye(3);
      zeros(3,1),  zeros(3,3),    zeros(3,3),    zeros(3,3);
      zeros(3,1),  zeros(3,3),    zeros(3,3),    zeros(3,3)];
aB = [zeros(4,6);
         eye(6)];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%Discrete-time%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
B = [zeros(4,6);
         eye(6)]*T;
A = eye(10) + T*aA;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%Safety constriant%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
b1 = 1/0.17;     %yaw
b2 = 1/0.13;     %height
b3 = 1/0.6;        %velocity


n = 12;
D = [0,    0,     0,    0,    0,    b1,     0,    0,    0,    0,    0,    0;
     0,    0,    b2,    0,    0,     0,     0,    0,    0,    0,    0,    0;
     0,    0,     0,    0,    0,     0,    b3,    0,    0,    0,    0,    0];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



bP = [1285.9377202263,0,0,-0,134.234258841582,0,0,0,0,0;
0,0.17314688950541,0,-0,0,0,0,0.022259508064187,0,0;
0,0,0.17314688950541,-0,0,0,0,0,0.022259508064187,-0;
-0,-0,-0,334.982863695047,-0,-0,-0,-0,-0,27.5625842890175;
134.234258841582,0,0,-0,18.8743782611975,0,0,0,0,0;
0,0,0,-0,0,0.00125247007725203,0,0,0,0;
0,0,0,-0,0,0,0.00125247007725203,0,0,0;
0,0.022259508064187,0,-0,0,0,0,0.00352098022744774,0,0;
0,0,0.022259508064187,-0,0,0,0,0,0.00352098022744774,0;
0,0,-0,27.5625842890175,0,0,0,0,0,2.72855076654556];

bP = bP*1;


eta = 1.2;
beta = 0.99;
kappa = 0.01;


setlmis([]) 
Q = lmivar(1,[10 1]); 
R = lmivar(2,[6 10]); 

lmiterm([-1 1 1 Q],1,(beta - 2*eta*kappa)*eye(10));
lmiterm([-1 2 1 Q],A,1);
lmiterm([-1 2 1 R],B,1);
lmiterm([-1 2 2 Q],1,0.5);

lmiterm([2 1 1 Q], eye(10), bP);
lmiterm([2 1 1 0], -eye(10));

lmiterm([3 1 1 Q], -eta*eye(10), bP);
lmiterm([3 1 1 0], eye(10));

mylmi = getlmis;


[tmin, psol] = feasp(mylmi);
Q = dec2mat(mylmi, psol, Q);
R = dec2mat(mylmi, psol, R);

P = inv(Q);

aF = round(aB*R*P,0)

eig(aA + aF)
eig(bP);




