import numpy as np


def tf_to_numpy(gradients):
    """
    A utility function to extracts gradients as numpy arrays,
    overcoming the fact that tensorflow stores things in a sparse way from time to time, etc.
    """
    try:
        G = gradients[0].numpy()
    except AttributeError:
        V = np.array(gradients[0].values)
        I = np.array(gradients[0].indices)
        G = np.zeros(gradients[0].dense_shape)
        for idx, val in zip(I, V):
            G[idx] = val

    return G


def load_shape_from_obj(file_path, with_faces=False):
    try:
        vertices = []
        if with_faces:
            faces = []
        with open(file_path) as f:
            for line in f:
                if line[0] == "v":
                    vertex = list(map(float, line[2:].strip().split()))
                    vertices.append(vertex)
                elif with_faces and (line[0] == "f"):
                    face = list(map(int, line[2:].strip().split()))
                    faces.append(face)

        if with_faces:
            return np.array(vertices), np.array(faces)
        return np.array(vertices)

    except FileNotFoundError:
        print(f"{file_path} not found.")
    except:
        print("An error occurred while loading the shape.")