from torch import nn

class LinearReg(nn.Module):
    def __init__(self, input_dim, output_dim) -> None:
        super().__init__()
        self.linear = nn.Linear(input_dim, output_dim)
        self.softmax = nn.Softmax()

    def forward(self, x):
        x = self.linear(x)
        return self.softmax(x)
