# Counterfactual Explanations of Image Anomaly Detectors 

Here we provide the implementation for the paper "Anomaly Detection Exposed: Imagining Anomalies Were Normal."
The implementation is based on PyTorch 2.1.2 and Python 3.10. The code is tested on Linux only.


## Table of contents

* [Installation](#installation)
* [Training](#training)
* [Log Data](#log-data)


## Installation
We recommend to use a virtual environment (e.g., **conda**) to install xad.

**conda**:

    conda create -n xad python=3.10
    conda activate xad
    python -m pip install -e xad/src

**Datasets**:

Most datasets are automatically downloaded once requested. 
However, ImageNet-1K and ImageNet-22K need to be downloaded manually.
Both datasets can be downloaded from https://image-net.org/, which requires a registration.
ImageNet-22K needs to be placed in `xad/data/datasets/imagenet22k/fall11_whole_extracted/`.
ImageNet-1K needs to be placed and extracted to `xad/data/datasets/imagenet/train/` and `xad/data/datasets/imagenet/val/`.


## Training
There are several pre-configured runners available.
All runners download datasets to `xad/data/datasets` and log results at `xad/data/results`.
As before, `xad/` refers to the root directory of this repository.  


### Train AD methods with full Outlier Exposure
The following scripts perform multiple trainings with different random seeds for a given normal definition.
A normal definition defines either a single class or a combination of classes to be normal.
For each seed, the scripts trains first the AD model (BCE per default) and then the counterfactual generator. 
The latter we call *xtraining* (for explanation training).
All parameters for the xtraining have an *x* prefix, e.g., `--x-epochs` for the number of epochs. 

Train with dataset {DS} for the normal class 1 and 2 being normal:

    python xad/src/xad/main/train_{DS}.py --classes 1+2

For example, with mnist:

    python xad/src/xad/main/train_mnist.py --classes 1+2

For convenience, Colored-MNIST also supports using "{color}+xor+{digit}" as a normal definition. For example:

    python xad/src/xad/main/train_colored_mnist.py --classes red+xor+one

There are several parameters that configure the training. Have a look at them with:

    python xad/src/xad/main/train_mnist.py -h

For example, you can train the counterfactual generator with five discrete anomaly scores for ten different random seeds executing:

    python xad/src/xad/main/train_mnist.py --x_discrete_anomaly_scores 5 --it 10

In principle, the scripts all execute the same code. They just differ in their default configuration. 


## Log Data

All results are automatically logged in a newly created folder in `xad/data/results/`.
The folder will have an auto-generated name starting with `log_{YYYYMMDDHHMMSS}_`, where {YYYYMMDDHHMMSS} is the current datetime (e.g., 20220128000000).

**AD Training**
In this folder you can find all results, most importantly, a `results.json` file that contains the recorded class-wise AUC scores along with some statistics like the standard deviation.
There also plots for the AUC curves, some image batches of the train and validation loader, and network snapshots.
You can find a precise enumeration below.

    xad/data/results/log_{YYYYMMDDHHMMSS}_{COMMENT}
    ├── snapshots                       
    │   ├── snapshot_cls{i}_it{j}.pt            # snapshot of the model and optimizer for class {i} and the {j}-th random seed
    │   ├── ...    
    │   └── ...
    ├── hist                       
    │   ├── C{i}-{clsname}-S{j}__anomaly_scores.pdf  # CDF of anomaly scores for training and test data, class {i}, and the {j}-th random seed
    │   ├── ...    
    │   └── ...
    ├── eval_cls{i}-{clsname}_prc.pdf           # test precision-recall curve of cls {i} with a plot for each random seed and the legend showing the average precision
    ├── ...
    ├── eval_cls{i}-{clsname}_preview.png       # an image showing random images retrived from the test dataloader; first row for normal and second row for anomalous; with the number of samples printed on the left
    ├── ...
    ├── eval_cls{i}-{clsname}_roc.pdf           # test receiver-operator-characteristic of cls {i} with a plot for each random seedd and the legend showing the AUC
    ├── ...
    ├── eval_prc.pdf                            # test precision-recall curve over all classes
    ├── eval_roc.pdf                            # test receiver-operator-characteristic over all classes
    ├── logtxt.txt                              # contains all computed metrics in the form of human-readable text 
    ├── print.txt                               # a log containing most of the printed messages
    ├── results.json                            # contains all computed metrics in the form of computer-readable json lines
    ├── setup.json                              # contains the configuration of the experiment in computer-readable format
    ├── src.tar.gz                              # contains the complete code that was used for the experiment
    ├── warnings.txt                            # contains a log of certain xad warnings
    ├── ...
    ├── training__C{i}-{clsname}_preview.png
    ├── ...
    ├── training__C{i}-{clsname}_roc.pdf
    └── ...

There is also a tensorboard logfile that contains most of the logged data. 

**Xtraining**
Log files for the counterfactual generator training can be found in a separate subfolder `counterfactual`.

    xad/data/results/log_{YYYYMMDDHHMMSS}_{COMMENT}/counterfactual
    ├── conditional_generation                       
    │   ├── test__C{i}-{clsname}-S{j}.pdf           # overview figure for some counterfactual generations for the test set, each row for a different condition with desired anomaly score *a* and concept *c*, the titles of the individual images show the actual anomaly score and classified concept
    │   ├── train__C{i}-{clsname}-S{j}.pdf          # overview figure for some counterfactual generations for the training set, each row for a different condition with desired anomaly score *a* and concept *c*, the titles of the individual images show the actual anomaly score and classified concept
    │   └── ...
    ├── cycle_generation
    │   ├── train__C{i}-{clsname}-S{j}.pdf          # some cycle-generated counterfactuals, i.e.; first row shows anomalies, second row a counterfactual, and the last two rows the reconstructed original with the true anomaly score 
    │   └── ...
    ├── hist                       
    │   ├── C{i}-{clsname}-S{j}__anomaly_scores.pdf  # CDF of anomaly scores for test data and counterfactuals, class {i}, and the {j}-th random seed
    │   ├── ...    
    │   └── ...
    ├── reconstruction                       
    │   ├── test__C{i}-{clsname}-S{j}.pdf           # some reconstructions of the generator for the test set, i.e., the generator is conditioned on a random concept and the true anomaly score
    │   ├── train__C{i}-{clsname}-S{j}.pdf          # some reconstructions of the generator for the training set, i.e., the generator is conditioned on a random concept and the true anomaly score
    │   └── ...
    ├── snapshots                       
    │   ├── snapshot_concept-clf_cls{i}_it{j}.pt    # snapshot of the concept classifier and optimizer for class {i} and the {j}-th random seed
    │   ├── snapshot_generator_cls{i}_it{j}.pt      # snapshot of the counterfactual generator and optimizer for class {i} and the {j}-th random seed
    │   └── ...
    ├── misc.json                                   # contains miscellaneous log data
    ├── print.txt                                   # a log containing most of the printed messages
    ├── results.json                                # contains all computed metrics (the CF AuROC, the normalized FID scores, etc.) in the form of computer-readable json lines
    ├── rocs_{i}_seed{j}.pdf                        # CF AuROC of normal training samples vs. counterfactuals, for class {i} and seed {j}
    ├── setup.json                                  # contains the configuration of the experiment in computer-readable format
    ├── warnings.txt                                # contains a log of certain xad warnings
    └── ...

There is also a tensorboard logfile that contains most of the logged data in more detail.
For example, loss plots. 
The conditional_generation folder also contains an "intermediate" subfolder with overview figures of reduced resolution at intermediate epochs of the xtraining.