import os
os.environ['OPENBLAS_NUM_THREADS'] = '1'
from typing import Tuple

import torch
import torchvision.transforms as transforms
from torchvision.transforms import Compose

from xad.models.resnets.concept_resnets import ConceptResNet64
from xad.models.resnets.resgan import ResNetGenerator224, \
    SNResNetProjectionDiscriminator224
from xad.models.resnets.resnet import WideResNet
from xad.main.bases import default_comment, main
from xad.models.bases import ADNN, ConditionalGenerator, ConditionalDiscriminator, ConceptNN


def modify_parser(parser):
    parser.set_defaults(
        comment=default_comment(__file__),
        objective='bce',
        dataset='mvtec',
        oe_dataset=['confetti'],
        epochs=200,
        learning_rate=1e-3,
        weight_decay=0,
        milestones=[150, 180],
        batch_size=128,
        devices=[0],
        classes=[5, ],
        iterations=2,
        x_discrete_anomaly_scores=3,
        # x_normal_training_only=True,
        x_batch_size=10,
        x_epochs=2500,
        x_learning_rate=2e-4,
        x_milestones=[2000, 2250],
        x_lamb_gen=1,
        x_lamb_asc=1,
        x_lamb_cyc=100,
        x_lamb_conc=10,
        x_gen_every=5,
        x_concepts=1,
        # x_cluster_ncc=True,
    )


def get_transforms() -> Tuple[Compose, Compose]:
    train_transform = transforms.Compose([
        transforms.Resize(224),
        # transforms.Resize(256),
        # transforms.RandomCrop(224),
        transforms.ColorJitter(brightness=0.01, contrast=0.01, saturation=0.01, hue=0.01),
        transforms.RandomHorizontalFlip(p=0.5),
        transforms.ToTensor(),
        # RandomGaussianNoise(0.001),
        # 'gcn-normalize'
    ])
    val_transform = Compose([
        transforms.Resize(224),
        # transforms.Resize(256),
        # transforms.CenterCrop(224),
        transforms.ToTensor(),
        # 'gcn-normalize'
    ])
    return train_transform, val_transform


def get_models(args) -> Tuple[ADNN, ConditionalGenerator, ConditionalDiscriminator, ConceptNN]:
    assert args.objective not in ('dsvdd', 'mdsvdd'), 'bias not implemented for WideResNet'
    model = WideResNet(clf=args.objective in ('bce', 'focal'))
    gen = ResNetGenerator224(1024, torch.Size([args.x_discrete_anomaly_scores, args.x_concepts]))
    disc = SNResNetProjectionDiscriminator224(1024, torch.Size([args.x_discrete_anomaly_scores]))
    concept_classifier = ConceptResNet64(args.x_concepts)  # 64 is fine
    return model, gen, disc, concept_classifier


if __name__ == '__main__':
    main(modify_parser, get_transforms, get_models)
