import os
os.environ['OPENBLAS_NUM_THREADS'] = '1'
from typing import Tuple

import torch
import torchvision.transforms as transforms
from torchvision.transforms import Compose

from xad.datasets.transformations import RandomGaussianNoise
from xad.models.cnn import CNN32
from xad.models.resnets.concept_resnets import ConceptResNet64
from xad.models.resnets.resgan import WideResNetGenerator32, \
    WideSNResNetProjectionDiscriminator32
from xad.main.bases import default_comment, main
from xad.models.bases import ADNN, ConditionalGenerator, ConditionalDiscriminator, ConceptNN


def modify_parser(parser):
    parser.set_defaults(
        comment=default_comment(__file__),
        objective='bce',
        dataset='cifar10',
        oe_dataset=['cifar100'],
        epochs=200,
        learning_rate=1e-3,
        weight_decay=0,
        milestones=[100, 150],
        batch_size=128,
        devices=[0],
        classes=["1+8", ],
        iterations=2,
        x_discrete_anomaly_scores=3,
        # x_normal_training_only=True,
        x_batch_size=64,
        x_epochs=350,
        x_learning_rate=2e-4,
        x_milestones=[300, 325],
        x_lamb_gen=1,
        x_lamb_asc=1,
        x_lamb_cyc=100,
        x_lamb_conc=10,
        x_gen_every=5,
        # x_cluster_ncc=True,
    )


def get_transforms() -> Tuple[Compose, Compose]:
    train_transform = transforms.Compose([
        transforms.RandomCrop(32, padding=1),
        transforms.RandomHorizontalFlip(p=0.5),
        transforms.ToTensor(),
        # 'normalize'
    ])
    val_transform = Compose([
        transforms.ToTensor(),
        # 'normalize'
    ])
    return train_transform, val_transform


def get_models(args) -> Tuple[ADNN, ConditionalGenerator, ConditionalDiscriminator, ConceptNN]:
    model = CNN32(bias=args.objective not in ('dsvdd', 'mdsvdd'), clf=args.objective in ('bce', 'focal'))
    gen = WideResNetGenerator32(1024, torch.Size([args.x_discrete_anomaly_scores, args.x_concepts]))
    disc = WideSNResNetProjectionDiscriminator32(1024, torch.Size([args.x_discrete_anomaly_scores]))
    concept_classifier = ConceptResNet64(args.x_concepts)  # 64 is fine
    return model, gen, disc, concept_classifier


if __name__ == '__main__':
    main(modify_parser, get_transforms, get_models)
