% Profile the speeds of W distance
% Load data
clear;

N = 10;
eta = 0.5;
n = 100;

mean_x = [1;1];
cov_x = [10, 1;1, 10];

mean_y = [2;2];
cov_y = [1, -0.2;-0.2, 1];

supp_x = mvnrnd(mean_x,cov_x, n)';
supp_y = mvnrnd(mean_y,cov_y, n)';

a = ones(1, n)/n;
b = ones(1, n)/n;

baseC = pdist2(supp_x', supp_y', 'sqeuclidean');
C = zeros(n, n, N);

for i = 1:N
    C(:,:, i) = abs(baseC + 10*randn(n));
end

max_iter = 10000;

clear options;
options.max_iter = max_iter;
options.N = N;
options.tau = 5 * eta / max(C,[], 'all')^2 ;
options.n = n;
[~, fval] = PAM(a, b, C, eta, options);

optimal = fval(max_iter+1);

save();

load();

max_iter = 2000;
clear options;
options.max_iter = max_iter;
options.N = N;
options.tau = 5 * eta / max(C,[], 'all')^2 ;
options.n = n;
[time1, fval1] = PAM(a, b, C, eta, options);

clear options;
options.max_iter = max_iter;
options.N = N;
options.n = n;
options.theta = 0.1;
options.tau = 5 * eta / max(C,[], 'all')^2 ;
[time, fval] = PAME(a, b, C, eta, options);

max_iter = 1800;
clear options;
options.max_iter = max_iter;
options.N = N;
options.n = n;
options.tau = 5 * eta / max(C,[], 'all')^2 ;
[time3, fval3] = APGA(a, b, C, eta, options);




%% Plots
fs = 20;
line_color = {[255, 128, 0], [76, 153, 0], [255,0,255], [204, 204, 0], [0, 0, 255], [255, 0, 0], [0, 123, 244], [0, 255, 0]};      

% Plot time
titlestr = sprintf('EOT Objective Error');   
figure;
semilogy(time1, abs(fval1 - optimal), '-r','LineWidth',2,'Color', line_color{2}/255) ;
hold on;
semilogy(time, abs(fval - optimal), '-r','LineWidth',2,'Color', line_color{1}/255) ;
hold on;
semilogy(time3, abs(fval3 - optimal), '-r','LineWidth',2,'Color', line_color{3}/255) ;
ax1 = gca;
set(ax1,'FontSize',fs);
xlabel(ax1,'Execution Time','FontName','Arial','FontSize',fs,'FontWeight','bold');
ylabel(ax1,'EOT Error','FontName','Arial','FontSize',fs,'FontWeight','bold');
a = legend( 'PAM', 'PAME', 'APGA');
set(a,'fontsize',12);
set(gca,'linewidth',2.5);
% title(titlestr);







