# Code for ...

## Setup repository
```bash
conda create -n env
conda activate env
pip install -r requirements.txt
cd diffusers/
pip install -e .
```
All experiment results will be saved under `results_<model_name>/`

## Localization of attention layers responsible for the generation of textual content

**SDXL**
```bash
PYTHONPATH=. python src/attention_localization_sdxl.py
```

**DeepFloyd IF**
```bash
PYTHONPATH=. python src/attention_localization_if.py
```

**SD3**
```bash
PYTHONPATH=. python src/attention_localization_sd3.py
```

## Image edition
**SDXL SimpleBench**
```bash
PYTHONPATH=. python src/edit_sdxl_glyph_simple.py
```

**SDXL CreativeBench**
```bash
PYTHONPATH=. python src/edit_sdxl_glyph_creative.py
```


**DeepFloyd IF SimpleBench**
```bash
PYTHONPATH=. python src/edit_if_glyph_simple.py
```
**DeepFloyd IF SimpleBench**
```bash
PYTHONPATH=. python src/edit_if_glyph_creative.py
```

**SD3**
```bash
PYTHONPATH=. python src/edit_sd3_glyph_simple.py
```

**SD3**
```bash
PYTHONPATH=. python src/edit_sd3_glyph_creative.py
```

## Start patching timestep search
**SDXL**
```bash
PYTHONPATH=. python src/timestep_search_sdxl.py
```

**DeepFloyd IF**
```bash
PYTHONPATH=. python src/timestep_search_if.py
```

**SD3**
```bash
PYTHONPATH=. python src/timestep_search_sd3.py
```


## LoRA SDXL fine-tuning
Prepare training dataset according to instructions in TextDiffuser repository.
1. Download googledrive folder and unzip with `src/mario-laion-unzip.py`
2. Create subset of links for dataset downloading using `src/random_subset.py`
3. Download dataset `img2dataset --url_list=url.txt --output_folder=laion_ocr --thread_count=64  --resize_mode=no`
4. Run `prepare_metadata.py` to prepare `metadata.jsonl` file with names of all pairs (image, caption)


**3 localized C-A layers**
```bash
export MODEL_NAME="stabilityai/stable-diffusion-xl-base-1.0"
export VAE_NAME="madebyollin/sdxl-vae-fp16-fix"
export PYTHONPATH=$(pwd):$PYTHONPATH

# run the code
accelerate launch diffusers/examples/text_to_image/train_text_to_image_lora_sdxl_3L.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --pretrained_vae_model_name_or_path=$VAE_NAME \
  --train_data_dir=train \
  --enable_xformers_memory_efficient_attention \
  --resolution=512 --center_crop \
  --train_batch_size=64 \
  --gradient_accumulation_steps=1 --gradient_checkpointing \
  --max_train_steps=10000 \
  --learning_rate=1e-06 --lr_scheduler="constant" --lr_warmup_steps=0 \
  --mixed_precision="fp16" \
  --report_to="wandb" \
  --checkpointing_steps=5000 \
  --output_dir="sdxl-lora-3-layers" \
  --validation_steps=500 \
  --seed=42
```

**All C-A layers**
```bash
export MODEL_NAME="stabilityai/stable-diffusion-xl-base-1.0"
export VAE_NAME="madebyollin/sdxl-vae-fp16-fix"
export PYTHONPATH=$(pwd):$PYTHONPATH

# run the code
accelerate launch diffusers/examples/text_to_image/train_text_to_image_lora_sdxl.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --pretrained_vae_model_name_or_path=$VAE_NAME \
  --train_data_dir=train \
  --enable_xformers_memory_efficient_attention \
  --resolution=512 --center_crop \
  --train_batch_size=64 \
  --gradient_accumulation_steps=1 --gradient_checkpointing \
  --max_train_steps=10000 \
  --learning_rate=1e-06 --lr_scheduler="constant" --lr_warmup_steps=0 \
  --mixed_precision="fp16" \
  --report_to="wandb" \
  --checkpointing_steps=5000 \
  --output_dir="sdxl-lora-all-layers" \
  --validation_steps=500 \
  --output_dir=sdxl-lora-all-layers \
  --seed=42 \
```

**Random 3 C-A layers**
```bash
export MODEL_NAME="stabilityai/stable-diffusion-xl-base-1.0"
export VAE_NAME="madebyollin/sdxl-vae-fp16-fix"
export PYTHONPATH=$(pwd):$PYTHONPATH
export TORCH_NCCL_HEARTBEAT_TIMEOUT_SEC=7200

accelerate launch --num-processes=4 diffusers/examples/text_to_image/train_text_to_image_lora_sdxl_3L_random.py \
  --pretrained_model_name_or_path=$MODEL_NAME \
  --pretrained_vae_model_name_or_path=$VAE_NAME \
  --train_data_dir=train \
  --enable_xformers_memory_efficient_attention \
  --resolution=512 --center_crop \
  --train_batch_size=128 \
  --val_batch_size=16 \
  --gradient_accumulation_steps=1 --gradient_checkpointing \
  --max_train_steps=7254 \
  --learning_rate=1e-06 --lr_scheduler="constant" --lr_warmup_steps=0 \
  --mixed_precision="fp16" \
  --report_to="wandb" \
  --checkpointing_steps=2000 \
  --validation_epochs=10 \
  --output_dir=sdxl-lora-random \
  --seed=42 \
  --target_layers 7 8 \
  --regex_start up_blocks.0.attentions.2.transformer_blocks
```

## Safety experiments
**Safe Diffusion SDXL**
```bash
PYTHONPATH=. python src/edit_sdxl_toxic.py
```

**Safe Diffusion DeepFloyd IF**
```bash
PYTHONPATH=. python src/edit_if_toxic.py
```

**Safe Diffusion SD3**
```bash
PYTHONPATH=. python src/edit_sd3_toxic_distr.py
```

**Negative prompt SDXL**
```bash
PYTHONPATH=. python src/edit_sdxl_glyph_toxic_distr.py
```


**Negative prompt DeepFloyd IF**
```bash
PYTHONPATH=. python src/edit_if_glyph_creative_distr.py
```

**Negative prompt SD3**
```bash
PYTHONPATH=. python src/edit_sd3_glyph_creative_distr.py
```
