import requests
import zipfile
import os

# Direct download link from Zenodo
url = "https://zenodo.org/records/14795434/files/eavae-data.zip?download=1"

# Get the directory where this script is located
script_dir = os.path.dirname(os.path.abspath(__file__))

# Paths relative to script
zip_path = os.path.join(script_dir, "eavae-data.zip")
target_dir = os.path.join(script_dir, "experiments")

# --- Step 1: Download zip to disk ---
print("Downloading zip file (this may take a while)...")
with requests.get(url, stream=True) as r:
    r.raise_for_status()
    with open(zip_path, "wb") as f:
        for chunk in r.iter_content(chunk_size=8192):
            f.write(chunk)

print("Download complete.")

# --- Step 2: Extract only the needed folder ---
wanted_prefix = "experiments/EAVAE_lognormal/"

print(f"Extracting only '{wanted_prefix}' to {target_dir}...")
with zipfile.ZipFile(zip_path, "r") as z:
    for member in z.namelist():
        if member.startswith(wanted_prefix) and not member.endswith("/"):
            # Compute relative path (strip "experiments/")
            relative_path = os.path.relpath(member, "experiments")
            target_path = os.path.join(target_dir, relative_path)

            # Make directories
            os.makedirs(os.path.dirname(target_path), exist_ok=True)

            # Extract file
            with z.open(member) as source, open(target_path, "wb") as target:
                target.write(source.read())

print("Extraction complete.")

# --- Step 3: Delete the zip file ---
os.remove(zip_path)
print("Deleted zip file, keeping only extracted folder.")
