# Expressiveness of Neural Networks Having Width Equal or Below the Input Dimension

This repository is the official PyTorch implementation for the numerical results of [Expressiveness of Neural Networks Having Width Equal or Below the Input Dimension](https://nips.cc/). 

If you want to cite our work, please use the following bibtex entry:

```
@article{
  TBC
}
```

## Requirements

To install requirements:

```setup
pip3 install -r requirements.txt
```

## Training

The hyperparameters for training are defined inside config .toml files in the cfg folder.
You can either create a new .toml file and change the path in the script train.py or modify the existing config file.
Then, you can simply start training by running

    $ python3 train.py 

## Experiment save folder structure
Each experiment saves automatically a number of files to keep track of the experiment.

| Folder / File | Contains                                                                                                       | 
| ------------- |----------------------------------------------------------------------------------------------------------------| 
| checkpoints   | The weights of the trained model.                                                                              | 
| data          | Numpy arrays of the predictions, targets and inputs for the final model, and intermediate steps.               | 
| images        | Plots for the dataset, the target and prediction vs. targets for intermediate steps as well as after training. |  
| logs          | Log file for the training.                                                                                     | 
| scripts       | A copy of the scripts used for training the model.                                                             | 
| cfg.toml      | A copy of the configuration file used for this training.    

## Evaluation

You can visualize the transformations learned by each layer and activation function as well as the final decision region.
You need change the experiment name in the file visualize_transformations.py to define which experiment to use.

    $ python3 visualize_transformations.py 


## Contributing

All contributions welcome! All content in this repository is licensed under the MIT license.

## Acknowledgment

This work was supported by TO BE COMPLETED