// Copyright 2023 The Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef FAIR_SUBMODULAR_MATROID_APPROXIMATE_FAIRNESS_ALGORITHM_H_
#define FAIR_SUBMODULAR_MATROID_APPROXIMATE_FAIRNESS_ALGORITHM_H_

#include <memory>
#include <string>
#include <vector>

#include "algorithm.h"
#include "fairness_constraint.h"
#include "matroid.h"
#include "submodular_function.h"

// WARNING: ONLY IMPLEMENTED FOR PARTITION MATROIDS!

class ApproximateFairnessAlgorithm : public Algorithm {
 public:
  // Constructor with epsilon parameter.
  explicit ApproximateFairnessAlgorithm(double epsilon);

  // Initialize the algorithm state.
  void Init(const SubmodularFunction& sub_func_f,
            const FairnessConstraint& fairness,
            const Matroid& matroid) override;

  // Handles insertion of an element.
  void Insert(int element) override;

  // Gets current solution value.
  double GetSolutionValue() override;

  // Gets current solution. Only call this after calling GetSolutionValue().
  std::vector<int> GetSolutionVector() override;

  // Gets the name of the algorithm.
  std::string GetAlgorithmName() const override;

 protected:
  // The final solution set.
  std::vector<int> solution_;

  std::vector<int> universe_elements_;

  double epsilon_;
};

#endif  // FAIR_SUBMODULAR_MATROID_APPROXIMATE_FAIRNESS_ALGORITHM_H_
