// Copyright 2020 The Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Random Subset Algorithm
//
// This algorithm shuffles the universe, then greedily adds elements
// as long as it's matroid-feasible and upper-bound-feasible.
//

#ifndef FAIR_SUBMODULAR_MAXIMIZATION_2020_RANDOM_SUBSET_ALGORITHM_H_
#define FAIR_SUBMODULAR_MAXIMIZATION_2020_RANDOM_SUBSET_ALGORITHM_H_

#include "algorithm.h"
#include "utilities.h"

class RandomAlgorithm : public Algorithm {
 public:
  // Initialize the algorithm state.
  virtual void Init(const SubmodularFunction& sub_func_f,
                    const FairnessConstraint& fairness,
                    const Matroid& matroid);


  // Handles insertion of an element.
  void Insert(int element);

  // Gets current solution value.
  double GetSolutionValue();

  // Gets current solution.
  std::vector<int> GetSolutionVector();

  // Gets the name of the algorithm.
  std::string GetAlgorithmName() const;

 private:

  // The solution (i.e. sampled elements), all the elements in the universe.
  std::vector<int> solution_, universe_elements_;
};

#endif  // FAIR_SUBMODULAR_MAXIMIZATION_2020_RANDOM_SUBSET_ALGORITHM_H_
