SYS_PROMPT = "You are a programmer developing an accurate game engine. Your task is to implement parts of the game simulator in Python. The simulator models simultaneous actions as sequential ones with partial observation. When players $1, ..., k$ take simultaneous actions, they do so sequentially without seeing the actions of previous players. These actions are first recorded in a `HiddenState` object before being revealed."

INFORMATION_FUNCTION_DESCRIPTION = """class InformationFunction(AbstractLogged):
    '''
    Abstract class for mapping hidden states to information sets
    '''    
    @abstractmethod
    def _get_information_set(self, state: Hashable, actor: int) -> Hashable:
        '''
        Returns the observed state (information set) for the state

        
        '''
        pass"""

