#!/bin/bash
#SBATCH --partition prod
#SBATCH --time=12:00:00
#SBATCH --job-name=llmgames_experiment
#SBATCH --output=slurm/llmgames_experiment_-%j.out
#SBATCH --error=slurm/llmgames_experiment_-%j.err
#SBATCH --mail-type=END,FAIL
#SBATCH --mail-user=jli@nec-labs.com
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=1

# Load necessary modules or activate conda environment if needed
# module load Python/3.8.2

# Activate conda environment if needed
# conda init
conda activate llmgames

# Run Python script with Hydra configuration files and additional arguments
# command to execute:
python3 -m src.experiment.run_dialogue_improve preset_modular_improve.generate_new_seed_functions=False env_preset=avalon_five_players preset_modular_improve=evolver_comp_avalon_dialogue_new preset_modular_improve.seed_function_file_directory='outputs/2024-05-20/22-30-06_1_seed' preset_modular_improve.evolutions=6 evolver_name=ImprovementLibrary feedback_method=simulated preset_modular_improve.batch_size=2
