import unittest
import heapq
from src.searchlight.utils import UpdatablePriorityDictionary

class TestUpdatablePriorityDictionary(unittest.TestCase):
    def setUp(self):
        self.updict = UpdatablePriorityDictionary()

    def test_add_update_remove(self):
        # Add and update an item
        self.updict.add_or_update_key("item", {"data": 100}, 5)
        self.updict.add_or_update_key("item", {"data": 150}, 5)
        self.assertEqual(self.updict.get_value("item"), {"data": 150})

        # Remove the item and test it's no longer accessible
        self.updict.remove_key("item")
        self.assertIsNone(self.updict.get_value("item"))

    def test_pop_key(self):
        self.updict.add_or_update_key("item1", {"data": 100}, 1)
        key, value, priority = self.updict.pop_key()
        self.assertEqual((key, value, priority), ("item1", {"data": 100}, 1))
        with self.assertRaises(KeyError):
            self.updict.pop_key()

    def test_get_top_k_items(self):
        self.updict.add_or_update_key("item1", {"data": 100}, 1)
        self.updict.add_or_update_key("item2", {"data": 200}, 2)
        # Update the value of an existing item, keeping the same priority
        self.updict.add_or_update_key("item1", {"data": 150}, 1)
        top_items = self.updict.get_top_k_items()
        self.assertEqual(len(top_items), 2)
        self.assertEqual(top_items[0][0], "item2")  # Highest priority item

