import unittest
from src.Avalon.baseline_models_Avalon import *
from src.searchlight.headers import *
from typing import Optional
from src.Avalon.engine import *


class TestAvalonActor(unittest.TestCase):
    # TODO: this needs to be updated

    def test_single(self):
        num_player = 6  # try 5, 6, 7, 8, 9, 10
        env = AvalonGameEnvironment.from_num_players(num_player)
        config = env.config

        quest_leader = env.quest_leader
        phase = env.phase
        turn = env.turn
        round = env.round
        done = env.done
        # self.good_victory = env.good_victory

        # make the following tuples so that they are immutable
        quest_team = frozenset(env.quest_team)
        team_votes = tuple(env.team_votes)
        quest_votes = tuple(env.quest_votes)
        quest_results = tuple(env.quest_results)
        roles = tuple(env.roles)

        state = AvalonState(config, quest_leader, phase, turn, round, done, env.good_victory, quest_team, team_votes, quest_votes, quest_results, roles, acting_player=quest_leader, simultaneous_actions=tuple())
        Avalon_actor = AvalonActorEnumerator()

        # phase 0
        state.phase = 0
        actor = Avalon_actor._enumerate(state)
        self.assertEqual(actor, {state.quest_leader})

        # phase 1 player 0
        state.phase = 1
        actor = Avalon_actor._enumerate(state)
        players = {0}
        self.assertEqual(actor, players)

        # phase 1 player 1
        state.simultaneous_actions = ((0,True),)
        actor = Avalon_actor._enumerate(state)
        players = {1}
        self.assertEqual(actor, players)

        # phase 1 player 2
        state.simultaneous_actions = ((0,True), (1,False))
        actor = Avalon_actor._enumerate(state)
        players = {2}
        self.assertEqual(actor, players)

        # phase 1 player 3
        state.simultaneous_actions = ((0,True), (1,False), (2,False))
        actor = Avalon_actor._enumerate(state)
        players = {3}
        self.assertEqual(actor, players)

        # phase 1 player 4
        state.simultaneous_actions = ((0,True), (1,False), (2,False), (3,False))
        actor = Avalon_actor._enumerate(state)
        players = {4}
        self.assertEqual(actor, players)

        # phase 2
        state.quest_team = tuple([1,4])
        state.phase = 2
        actor = Avalon_actor._enumerate(state)
        self.assertEqual(actor, set(state.quest_team))

        # phase 3
        state.phase = 3
        actor = Avalon_actor._enumerate(state)
        self.assertEqual(actor, set([state.get_assassin()]))

        # game ended
        state.done = True
        actor = Avalon_actor._enumerate(state)
        self.assertEqual(actor, set())


if __name__ == "__main__":
    unittest.main()