import numpy as np
import matplotlib.pyplot as plt


performance_history_avalon_seed0 = np.load('./performance_history_Avalon_seed0.npy')
performance_history_avalon_seed1 = np.load('./performance_history_Avalon_seed1.npy')
performance_history_avalon_seed2 = np.load('./performance_history_Avalon_seed2.npy')
performance_history_avalon_seed3 = np.load('./performance_history_Avalon_seed3.npy')
performance_history_avalon_seed4 = np.load('./performance_history_Avalon_seed4.npy')

# performance_history_avalon_seed5 = np.load('./performance_history_Avalon_seed5.npy')
# performance_history_avalon_seed6 = np.load('./performance_history_Avalon_seed6.npy')
# performance_history_avalon_seed7 = np.load('./performance_history_Avalon_seed7.npy')
# performance_history_avalon_seed8 = np.load('./performance_history_Avalon_seed8.npy')
# performance_history_avalon_seed9 = np.load('./performance_history_Avalon_seed9.npy')


window = 5
N = len(performance_history_avalon_seed0)
running_avg_seed0 = np.empty(N)
running_avg_seed1 = np.empty(N)
running_avg_seed2 = np.empty(N)
running_avg_seed3 = np.empty(N)
running_avg_seed4 = np.empty(N)
# running_avg_seed5 = np.empty(N)
# running_avg_seed6 = np.empty(N)
# running_avg_seed7 = np.empty(N)
# running_avg_seed8 = np.empty(N)
# running_avg_seed9 = np.empty(N)
for t in range(N):
    running_avg_seed0[t] = np.mean(performance_history_avalon_seed0[max(0, t - window):(t + 1)])
    running_avg_seed1[t] = np.mean(performance_history_avalon_seed1[max(0, t - window):(t + 1)])
    running_avg_seed2[t] = np.mean(performance_history_avalon_seed2[max(0, t - window):(t + 1)])
    running_avg_seed3[t] = np.mean(performance_history_avalon_seed3[max(0, t - window):(t + 1)])
    running_avg_seed4[t] = np.mean(performance_history_avalon_seed4[max(0, t - window):(t + 1)])
    # running_avg_seed5[t] = np.mean(performance_history_avalon_seed5[max(0, t - window):(t + 1)])
    # running_avg_seed6[t] = np.mean(performance_history_avalon_seed6[max(0, t - window):(t + 1)])
    # running_avg_seed7[t] = np.mean(performance_history_avalon_seed7[max(0, t - window):(t + 1)])
    # running_avg_seed8[t] = np.mean(performance_history_avalon_seed8[max(0, t - window):(t + 1)])
    # running_avg_seed9[t] = np.mean(performance_history_avalon_seed9[max(0, t - window):(t + 1)])


# performance_history_avalon_all = np.array([performance_history_avalon_seed0, performance_history_avalon_seed5, performance_history_avalon_seed10, performance_history_avalon_seed15, performance_history_avalon_seed20])
# performance_history_avalon_all = np.array([running_avg_seed0, running_avg_seed1, running_avg_seed2, running_avg_seed3,
#                                          running_avg_seed4, running_avg_seed5, running_avg_seed6, running_avg_seed7,
#                                          running_avg_seed8, running_avg_seed9])
performance_history_avalon_all = np.array([running_avg_seed0, running_avg_seed1, running_avg_seed2, running_avg_seed3,
                                         running_avg_seed4])
#########################
#########################
#########################
#########################
plt.figure()
# plt.rcParams['axes.facecolor'] = 'whitesmoke'
fig, ax = plt.subplots()
# ax.grid()

means_performance_history_avalon = np.mean(performance_history_avalon_all, axis=0)
index = [i+1 for i in range(len(means_performance_history_avalon))]
stds_performance_history_avalon = np.std(performance_history_avalon_all, axis=0)
ax.plot(index, means_performance_history_avalon, linewidth=2, label="RL", color='red')
ax.fill_between(index, means_performance_history_avalon-stds_performance_history_avalon, means_performance_history_avalon+stds_performance_history_avalon, alpha=0.2, color='red')
plt.ylabel('Performance', fontsize=14)
plt.xlabel("Evolution", fontsize=14)
plt.xlim(0, len(index))
plt.xticks(fontsize=11)
plt.yticks(fontsize=11)
# plt.xticks(np.arange(min(index), max(index)+1, 1))

plt.savefig('avalon_rl_improve.png')
