import unittest
from src.Avalon.baseline_models_Avalon import AvalonLLMFunctionalValueHeuristic
from src.GOPS.baseline_models_GOPS import LLMFunctionalValueHeuristic
from src.searchlightimprove.utils import parse_improvement_list

class TestSelfImproveParsep(unittest.TestCase):
    text = """1.) Consider incorporating the knowledge of opponent's strategy into the heuristic. Currently, the function only calculates the potential score based on the player's own hand and the remaining score cards. By also factoring in possible strategies or card choices by the opponent, the heuristic can better estimate the actual outcome of the game.

2.) Introduce a randomness factor in the heuristic to account for uncertainty in the game. Since GOPS involves drawing cards randomly, there is inherent uncertainty in the game outcomes. By adding a stochastic element to the heuristic, the function can better capture the variability in potential game states.

3.) Implement a dynamic evaluation function that adjusts its evaluation criteria based on the current game state. Instead of relying on fixed calculations, the function can adapt its evaluation strategy based on factors such as the number of rounds played, the cards played by both players, and the current score differentials. This dynamic approach can lead to more accurate evaluations in different game scenarios.
"""
    parsed_list = [
        "Consider incorporating the knowledge of opponent's strategy into the heuristic. Currently, the function only calculates the potential score based on the player's own hand and the remaining score cards. By also factoring in possible strategies or card choices by the opponent, the heuristic can better estimate the actual outcome of the game.",
        "Introduce a randomness factor in the heuristic to account for uncertainty in the game. Since GOPS involves drawing cards randomly, there is inherent uncertainty in the game outcomes. By adding a stochastic element to the heuristic, the function can better capture the variability in potential game states.",
        "Implement a dynamic evaluation function that adjusts its evaluation criteria based on the current game state. Instead of relying on fixed calculations, the function can adapt its evaluation strategy based on factors such as the number of rounds played, the cards played by both players, and the current score differentials. This dynamic approach can lead to more accurate evaluations in different game scenarios."
        ]
    
    value_heuristics_gops = """# Test
def evaluate_state(state) -> tuple[int, int]:
    # Unpack the state tuple
    score_cards = state[0]
    my_played_cards = state[1]
    opponent_played_cards = state[2]
    is_turn = state[3]
    my_score = state[4]
    opponent_score = state[5]
    score_deck = state[6]
    my_hand = state[7]
    opponent_hand = state[8]

    intermediate_values = {'my_hand': my_hand, 'opponent_hand': opponent_hand}
    
    return (my_score, opponent_score), intermediate_values
# an addition line
"""

    value_heuristics_avalon = """def evaluate_state(state):
    # Extracting state information
    players = state['players']
    turn = state['turn']
    phase = state['phase']
    round = state['round']
    quest_leader = state['quest_leader']
    quest_team = state['quest_team']
    historical_quest_results = state['historical_quest_results']
    historical_team_votes = state['historical_team_votes']
    num_good = state['num_good']
    num_evil = len(players) - num_good
    num_participants_per_quest = state['num_participants_per_quest']
    num_fails_per_quest = state['num_fails_per_quest']

    # Initialising players' expected win rates
    player_rates = {p: 0.5 for p in players} # Since we don't have any information about roles yet

    # Calculating intermediate values:
    total_quests = len(num_participants_per_quest)
    total_rounds = 5 # In every turn, there can be at most 5 rounds of discussions
    quests_passed = sum(historical_quest_results) 
    quests_failed = turn - quests_passed # Subtract quests passed from total quests attempted
    rounds_failed = sum([1 for vote in historical_team_votes if vote is False])

    if quests_passed == 3: # 3 Successful Quests for Good Team => Good team wins
        player_rates = {player: (1 if player in quest_team else 0) for player in players}
    elif quests_failed == 3: # 3 Successful Quests for Evil Team => Evil team wins
        player_rates = {player: (1 if player not in quest_team else 0) for player in players}
    else:
        # More successful quests increase win rates for the quest team
        for player in quest_team:
            player_rates[player] += quests_passed / total_quests
        
        # More failed quests increase win rates for the non-quest team
        for player in players - quest_team:
            player_rates[player] += quests_failed / total_quests
   
    # Calculate extra score for non-rejected rounds
    for qb in historical_team_votes:
        if qb: # If a quest team is approved, increase win rate for quest team members
            for player in quest_team:
                player_rates[player]+= 0.1
        else: # If it is rejected, increase win rate for non-quest team members
            for player in players - quest_team:
                player_rates[player]+= 0.1

    
    intermediate_values = {'turn' : turn,
                            'quests_passed' : quests_passed,
                            'quests_failed' : quests_failed,
                            'rounds_failed' : rounds_failed}
    
    return player_rates, intermediate_values"""

    def test_parse_improvement_list(self):
        self.assertEqual(parse_improvement_list(self.text), self.parsed_list)

    def test_heuristic_parser(self):
        self.assertTrue(AvalonLLMFunctionalValueHeuristic.test_evaluate_static(self.value_heuristics_avalon))
        self.assertTrue(AvalonLLMFunctionalValueHeuristic.parse_llm_generated_function(self.value_heuristics_avalon))
        self.assertTrue(LLMFunctionalValueHeuristic.test_evaluate_static(self.value_heuristics_gops))

if __name__ == '__main__':
    unittest.main()