# Learning without Prejudices: Continual Unbiased Learning via Benign and Malignant Forgetting
Implementation of **L**earning **w**ithout **P**rejudices (LwP).
## Prerequisites
Our implementations are conducted on following settings
```
python==3.9
torch==1.7.0
torchvision==0.8.2
```

## Project Structure

This project relies on the following folder organisation:
```
├───dataset                             # folder of dataset
|   ├───MNIST-BIASED                    
|       ├───MNIST                       # original MNIST dataset
|       └───MNIST-BIASED-BG-Biased*     # Biased MNIST dataset generated by make_dataset.py
│   ├───loader.py                       # data loader
│   └───mnist.py                        # Biased MNIST dataset
├───model
|   ├───lwp                             # LwP
|   |   ├───gen                         # feature generator
|   |   |   ├───__init__.py
|   |   |   ├───generator.py
|   |   |   ├───wgan.py
|   |   ├───ssl                         # self-supervised learninge
|   |   |   ├───__init__.py
|   |   |   ├───base.py
|   |   |   ├───byol.py
|   |   ├───__init__.py
|   |   ├───lwp_model.py                # LwP
|   ├───buffer.py                          
|   ├───module.py
|   ├───simple_convnet.py               # backbone network
├───exps                                # saved weights and logs in training
├───train.py                            # training code
├───eval.py                             # evalulation code
├───make_dataset.py                     # make Colored Biased MNIST
├───option.py                           
├───traininer.py                        
└───utils.py                            
```

## Make Dataset
- Colored Biased MNIST
```
python make_dataset.py --data mnist-biased --split both --biased_ratio 0.85
```

## Train

```sh
# Baseline
python train.py --exp_name Exp --epoch 20 --biased_r 0.85 --method base 

# Learning without Prejudices
python train.py --exp_name Exp --epoch 20 --biased_r 0.85 --method lwp

# Learning without Prejudices (Replay version)
python train.py --exp_name Exp --epoch 20 --biased_r 0.85 --method lwp --replay
```

## Evaluation
```sh
python eval.py --exp_path <path to experiment>
```



