params = {
    'type': 'MultitaskCQL',
    'universe': 'gym',
    'domain': 'SawyerDoorDrawerMultitask',
    'task': 'v2',

    'log_dir': 'logs/',
    'exp_name': 'off_policy_cql_minq_1.0_lagrange_0.0_lr1e-4_qlr3e-4_temp1.0_deterministic_mr_e_mr_e_cuds',

    'kwargs': {
        'epoch_length': 200,
        'eval_n_episodes': 4*5,
        'eval_deterministic': False,
        'lr': 1e-4,
        'q_lr': 3e-4,
        # min Q
        'with_min_q': True,
        'min_q_for_real': False,
        'min_q_for_real_and_fake': False,
        'min_q_for_fake_only': False,
        'min_q_for_fake_states': False,
        'min_q_for_real_fake_states': False,
        'min_q_real_states_weight': 1.0,
        'backup_for_fake_only': False,
        'backup_with_uniform': False,
        'learn_bc_policy': False,
        'learn_bc_epoch': 50,
        'temp': 1.0,
        'min_q_version': 3,
        'min_q_weight': 1.0,
        'data_subtract': True,
        # extra params
        'num_random': 10,
        'max_q_backup': False,
        'deterministic_backup': True,
        # lagrange
        'with_lagrange': False,
        'lagrange_thresh': 10.0,

        'model_train_freq': 1000,
        'model_retain_epochs': 5,
        'rollout_batch_size': 50e3,
        'deterministic': False,
        'rollout_random': False,
        'num_networks': 7,
        'num_elites': 5,
        'real_ratio': 1.0,
        'target_entropy': -3,
        'max_model_t': None,
        'rollout_length': 1, 
        'multi_step_prediction': False,
        'num_plan_steps': 3,#10,

        'num_tasks': 4,
        'use_relabel_weights': True,
        'use_relabel_weights_diff': False,
        'relabel_balance_batch': True,
        'relabel_weight_temp': 20.0,
        'relabel_weight_temp_adaptive': True,
        'relabel_weight_temp_adaptive_per_task': True,
        'relabel_weight_temp_tau': 0.995,#5e-3,
        'relabel_weight_temp_min': 1.0,
        'relabel_weight_temp_max': 50.0,
        'relabel_weight_orig_task': False,
        'relabel_prob': 0.5,


        'sn': False,
        'separate_mean_var': False,
        'penalty_learned_var': False,
        'penalty_coeff': 0.0, #1.0
        'pool_load_path': ['/path/to/cuds/data/metaworld_task0.pkl', '/path/to/cuds/data/metaworld_task1.pkl', '/path/to/cuds/data/metaworld_task2.pkl', '/path/to/cuds/data/metaworld_task3.pkl'],
        'pool_load_max_size': 150e3*4, ####
        'model_name': 'sawyer_door_drawer_sn_smv_1_0',
        'multitask_type': 'relabel-all',
    }
}