"""Explore the environment with high-level options"""
from gym_montezuma.envs.montezuma_env import MontezumasRevengeEnv

if __name__ == "__main__":
    # Clips the perfect plan with 90% probability at a random point.
    env = MontezumasRevengeEnv(render_mode="human", clip_eps=0.9, single_screen=True)
    option_dict = {}
    for i in range(100):
        env.reset()
        done = False
        total_reward = 0
        while not done:
            action = env.action_space.sample()
            frame, reward, terminated, truncated, info = env.step(action)
            total_reward += reward
            done = terminated or truncated
            print(f"Total reward={total_reward}")
    env.close()
