import argparse
from cycler import cycler
import matplotlib.pyplot as plt
import numpy as np
import os
import random
import time
import torch

# _word_file = "/usr/share/dict/words"
# _WORDS = open(_word_file).read().splitlines()
# good = lambda x: len(x) > 3 and len(x) < 11 and x[0].islower() and x.isalpha()
# _WORDS = list(filter(good, _WORDS))

random_word = "hellogibberish"
# del _WORDS, _word_file

def get_time_string(format="%Y%m%d-%H%M%S"):
    return time.strftime(format)

def create_log_dir(name):
    log_dir = 'logs/' + str(name) + '_' + get_time_string()
    os.makedirs(log_dir, exist_ok=True)
    return log_dir

def reset_seeds(seed=None):
    np.random.seed(seed)
    random.seed(seed)
    if seed is not None:
        torch.manual_seed(seed)
        if torch.cuda.is_available():
            # torch.cuda.manual_seed_all(seed)
            torch.backends.cudnn.deterministic = True

def show_image(img, show=True, cmap='gray'):
    img = img.squeeze()
    img = (img+1)/2
    if len(img.shape) == 3 == img.shape[0]:
        img = img.transpose(0, -1)
        img = img.transpose(0, 1)
    plt.imshow(img, vmin=-1, vmax=1, cmap=cmap)
    if show:
        plt.show()

def show_batch_images(images, n_cols=None, titles=None, show=True, cmap='gray'):
    if titles is None and n_cols is None:
        n_cols = 3
    elif n_cols is None:
        #titles not none
        n_cols = len(titles)

    n_grid = np.ceil(len(images)/n_cols)*n_cols
    n_rows = int(n_grid//n_cols)
    i = 0
    for row in range(n_rows):
        for col in range(n_cols):
            plt.subplot(n_rows, n_cols, i+1)
            img = images[i]
            show_image(img, show=False, cmap=cmap)
            plt.axis('off')
            if titles is not None and len(titles) > i:
                plt.title(titles[i])
            i += 1
            if i >= len(images):
                break
        if i >= len(images):
            break
    if show:
        plt.show()

def reset_color_cycler(new_cycler=None):
    ax = plt.gca()
    current_cycler = ax._get_lines.prop_cycler#plt.rcParams['axes.prop_cycle']
    current_colors = plt.rcParams['axes.prop_cycle'].by_key()['color']
    next_color = next(current_cycler)['color']
    next_idx = current_colors.index(next_color)
    restored_colors = current_colors[next_idx:] + current_colors[:next_idx]
    restored_cycler = cycler('color', restored_colors)
    if cycler is None:
        new_cycler = cycler('color', current_colors)
    ax.set_prop_cycle(new_cycler)
    return restored_cycler

def plot_labeled_point(x, y, label):
    plt.plot(x,y,'.')
    txt = plt.annotate(
        label,
        xy=(x,y), xytext=(5, 2),
        textcoords='offset points', ha='right', va='bottom',
#         bbox=dict(boxstyle='round,pad=0.5', fc='yellow', alpha=0.5),
#         arrowprops=dict(arrowstyle = '->', connectionstyle='arc3,rad=0')
    )
    txt.set_size(6)

def printDict(d):
    # Print the contents of a dictionary in alphabetical order
    print("=========================================================")
    for key in sorted(d.keys()):
        print("{}: {}".format(key, d[key]))

def get_parser():
    """Return a nicely formatted argument parser

    This function is a simple wrapper for the argument parser I like to use,
    which has a stupidly long argument that I always forget.
    """
    return argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
