from gym_montezuma.envs import MontezumasRevengeEnv
from gym_montezuma.envs.montezuma_env import Option
from gym_montezuma.envs.wrappers import WarpFrame, FrameSkipStackPool
from pix2sym.utils.file_io import saveMP4

from pix2sym.montezuma import newplans

if __name__ == '__main__':

    env = MontezumasRevengeEnv(render_option_execution=False, seed=0, single_screen=False)
    env = WarpFrame(env)
    env = FrameSkipStackPool(env, 4, 4)
    plan = newplans.plan

    ims = list()
    obs = env.reset()
    env.render()
    for step, option in enumerate(plan):
        if step >= len(plan) - 25:
            env.unwrapped._render_option_execution = True
        obs, reward, done, info = env.step(option)
        for i in range(1, len(info['frames'])):
            ims.append(info['frames'][i])
        env.render()
        for _ in range(10000):
            option = env.action_space.sample()
            print(env.get_action_meanings()[option])
            obs, reward, done, info = env.step(option)
            if done:
                break
            env.render()
    env.close()
