import numpy as np

from .atarienv import AtariEnv
from ..ramops import getByte, bcd2int, getByteRange

class MsPacmanEnv(AtariEnv):
    def __init__(self, *args, **kwargs):
        super().__init__('pacman', *args, **kwargs)

    def parseRAM(self, ram):
        state = {}
        memory_map = {
            'screen':        '80',
            'orange_status': '81',
            'blue_status':   '82',
            'pink_status':   '83',
            'red_status':    '84',
            'orange_x':      '86',
            'blue_x':        '87',
            'pink_x':        '88',
            'red_x':         '89',
            'pac_x':         '8A',
            'orange_y':      '8C',
            'blue_y':        '8D',
            'pink_y':        '8E',
            'red_y':         '8F',
            'pac_y':         '90',
        }
        for sprite, addr in memory_map.items():
            state[sprite] = getByte(ram, addr)

        dot_bytes = getByteRange(ram, 'BB', 'E5')
        dot_array = np.full([14, 18], False, dtype=bool)
        for i, dot_byte in enumerate(dot_bytes):
            row = int(i // 3)
            if i % 3 == 0:
                # left and right edge dots
                dot_array[row, 0]  = dot_byte & 0x40
                dot_array[row, 17] = dot_byte & 0x10
            elif i % 3 == 1:
                # 4-dot groups A & C
                dot_array[row,  1] = dot_byte & 0x80
                dot_array[row,  2] = dot_byte & 0x20
                dot_array[row,  3] = dot_byte & 0x08
                dot_array[row,  4] = dot_byte & 0x02
                dot_array[row,  9] = dot_byte & 0x40
                dot_array[row, 10] = dot_byte & 0x10
                dot_array[row, 11] = dot_byte & 0x04
                dot_array[row, 12] = dot_byte & 0x01
            else:
                # 4-dot groups B & D
                dot_array[row,  5] = dot_byte & 0x01
                dot_array[row,  6] = dot_byte & 0x04
                dot_array[row,  7] = dot_byte & 0x10
                dot_array[row,  8] = dot_byte & 0x40
                dot_array[row, 13] = dot_byte & 0x02
                dot_array[row, 14] = dot_byte & 0x08
                dot_array[row, 15] = dot_byte & 0x20
                dot_array[row, 16] = dot_byte & 0x80
        state['dots'] = dot_array

        for key in ['orange_status','blue_status','pink_status','red_status']:
            modes = ['free']*4 + ['eaten','slow (?)','eaten','jail']
            move_dirs = ['up','right','down','left']
            status = state[key]
            mode = modes[(status >> 4) & 0x7]
            edible = bool(status & 0x80)
            move_dir = move_dirs[status & 0x03]
            state[key] = {'mode': mode, 'edible': edible, 'move_dir': move_dir}
        return state
