import datetime
import gym
import numpy as np
import sys

from .envs import MsPacmanEnv
from .. import utils
from random import randint

def runEpisode(env, seed=None, render=False, max_steps=None, reset_env=True):
    if reset_env:
        env.reset(seed)

    FPS = 60 / env.frameskip
    last_update = datetime.datetime.now()
    update_time = datetime.timedelta(milliseconds=1000 / FPS)

    obs = []
    states = []
    actions = []
    score = 0

    done = False
    while not done and (max_steps == None or len(actions) < max_steps):
        now = datetime.datetime.now()
        if not render or (now - last_update > update_time):
            if render:
                last_update = now
                env.render()
            action = np.random.choice(env.n_actions)
            ob, reward, done, _ = env.step(action)
            state = env.getState()
            score += reward
            obs.append(ob)
            actions.append(action)
            states.append(state)

    result = obs, actions, score, states
    return result

def main(seed=None, render=False):
    utils.reset_seeds(seed=seed)
    env = MsPacmanEnv()
    obs, actions, score, states = runEpisode(env, seed=seed, render=render)
    env.close()
    print('Observed frames:', len(obs))
    print('Action counts:', np.bincount(actions))
    print('Score:', score)

if __name__ == '__main__':
    parser = utils.get_parser()
    parser.add_argument('-s', '--seed', help='Random seed', type=int, default=None)
    parser.add_argument('--render', help='Render environment', action='store_true')
    args = parser.parse_args()
    main(seed=args.seed, render=args.render)
