from enum import IntEnum


class o(IntEnum):
    WAIT_RESPAWN = 0
    RUN_LEFT = 1
    RUN_RIGHT = 2
    DOWN_ROPE = 3
    UP_ROPE = 4
    DROP_ROPE = 5
    DOWN_LADDER = 6
    UP_LADDER = 7
    JUMP = 8
    JUMP_LEFT = 9
    JUMP_RIGHT = 10
    CLIMB_PLATFORMS = 11
    WAIT_LASER_DISAPPEAR = 12
    WAIT_LASER_APPEAR = 13
    WAIT_BRIDGE_DISAPPEAR = 14
    WAIT_BRIDGE_APPEAR = 15
    WAIT_SPIDER_TOWARDS = 16
    WAIT_SPIDER_AWAY = 17
    WAIT_SKULL_TOWARDS = 18
    WAIT_SKULL_AWAY = 19
    WAIT_JUMP_SKULL_TOWARDS = 20
    WAIT_JUMP_SKULL_AWAY = 21
    PASS_LEFT_JUMP_SKULL = 22
    PASS_RIGHT_JUMP_SKULL = 23
    CHARGE_LEFT = 24
    CHARGE_RIGHT = 25
    WAIT_LEVEL = 26


class Room01:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            plan = [o.JUMP_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT, o.DOWN_LADDER]
            if level == 0:
                plan += [o.WAIT_SKULL_TOWARDS]
            plan += [
                o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT, o.UP_LADDER, o.JUMP_LEFT, o.RUN_RIGHT,
                o.DOWN_LADDER
            ]
            if level in [1, 2]:
                plan += [o.WAIT_SKULL_AWAY, o.WAIT_SKULL_TOWARDS]
            plan += [
                o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT, o.UP_LADDER, o.RUN_LEFT, o.JUMP_LEFT,
                o.JUMP_LEFT, o.RUN_LEFT, o.UP_LADDER, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT,
                o.RUN_LEFT
            ]
        return plan

class Room00:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            plan = [o.RUN_LEFT]
            if level == 0:
                plan += [o.WAIT_LASER_APPEAR]
            plan += [
                o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT, o.WAIT_LASER_APPEAR, o.WAIT_LASER_DISAPPEAR,
                o.RUN_LEFT
            ]
            if level == 2:
                plan += [o.DOWN_LADDER, o.DOWN_LADDER]
            else:
                plan += [
                    o.RUN_LEFT, o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT,
                    o.WAIT_LASER_DISAPPEAR, o.RUN_RIGHT, o.DOWN_LADDER, o.DOWN_LADDER
                ]
            return plan

class Room04:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            if level == 2:
                return [
                    o.UP_LADDER, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT,
                    o.RUN_LEFT
                ]
            plan = [o.DOWN_LADDER, o.RUN_LEFT]
            if level == 1:
                plan += [o.JUMP_LEFT, o.RUN_LEFT]
            plan += [o.RUN_LEFT]
            return plan
        elif direction == 'down':
            plan = [o.RUN_RIGHT, o.JUMP_RIGHT]
            if level == 0:
                plan += [o.WAIT_SPIDER_TOWARDS, o.RUN_LEFT]
            elif level == 1:
                plan += [o.RUN_RIGHT]
            elif level == 2:
                plan += [o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT]
            plan += [o.DOWN_LADDER, o.DOWN_LADDER]
            return plan
        elif direction == 'climb_through':
            return [o.DOWN_LADDER, o.DOWN_LADDER, o.DOWN_LADDER]

class Room03:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            if level == 0:
                return [o.PASS_LEFT_JUMP_SKULL, o.RUN_LEFT, o.DOWN_LADDER, o.DOWN_LADDER]
            elif level == 1:
                return [
                    o.RUN_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_RIGHT, o.DOWN_LADDER, o.DOWN_LADDER
                ]
            elif level == 2:
                return [
                    o.RUN_LEFT, o.JUMP, o.RUN_LEFT, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT, o.DOWN_LADDER,
                    o.DOWN_LADDER
                ]
        elif direction == 'right':
            plan = []
            if level == 0:
                plan += [o.WAIT_JUMP_SKULL_AWAY]
            plan += [o.UP_LADDER, o.RUN_RIGHT]
            if level == 0:
                plan += [o.WAIT_JUMP_SKULL_TOWARDS, o.PASS_RIGHT_JUMP_SKULL, o.RUN_RIGHT]
            plan += [o.RUN_RIGHT]
            return plan

class Room09:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            if level == 2:
                return [o.DOWN_LADDER, o.RUN_LEFT, o.CHARGE_LEFT, o.RUN_LEFT, o.RUN_LEFT]
            plan = [o.DOWN_LADDER, o.RUN_LEFT, o.JUMP_LEFT]
            if level == 0:
                plan += [o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT]
            plan += [o.RUN_LEFT]
            return plan
        elif direction == 'up':
            if level == 2:
                return [o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER]
            plan = [o.RUN_RIGHT, o.JUMP_RIGHT]
            if level == 0:
                plan += [o.RUN_RIGHT, o.JUMP_RIGHT]
            plan += [o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER]
            return plan

class Room08:
    @classmethod
    def go(cls, direction, level):
        if direction == 'right':
            if level == 0:
                return [
                    o.RUN_LEFT, o.JUMP_LEFT, o.UP_ROPE, o.JUMP, o.DOWN_ROPE, o.DROP_ROPE,
                    o.RUN_RIGHT, o.CLIMB_PLATFORMS, o.RUN_RIGHT
                ]
            else:
                plan = [
                    o.RUN_LEFT, o.JUMP_LEFT, o.DOWN_ROPE, o.DROP_ROPE, o.RUN_LEFT,
                    o.CLIMB_PLATFORMS
                ]
                if level == 2:
                    plan += [o.JUMP_RIGHT]
                plan += [
                    o.RUN_RIGHT, o.JUMP_RIGHT, o.DOWN_ROPE, o.DROP_ROPE, o.RUN_RIGHT,
                    o.CLIMB_PLATFORMS, o.RUN_RIGHT
                ]
                return plan

class Room10:
    @classmethod
    def go(cls, direction, level):
        if direction == 'right':
            plan = [o.DOWN_LADDER, o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR, o.DOWN_LADDER]
            if level in [0, 1]:
                plan += [
                    o.RUN_LEFT, o.RUN_LEFT, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT, o.WAIT_BRIDGE_APPEAR,
                    o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT
                ]
            elif level == 2:
                plan += o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT
            return plan
        if direction == 'up':
            return [
                o.DOWN_LADDER, o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR, o.DOWN_LADDER,
                o.RUN_LEFT, o.RUN_LEFT, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT, o.WAIT_BRIDGE_APPEAR,
                o.RUN_RIGHT, o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER, o.UP_LADDER
            ]
        if direction == 'up':
            return [
                o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT, o.UP_LADDER,
                o.UP_LADDER
            ]

class Room11:
    @classmethod
    def go(cls, direction, level):
        if direction == 'up':
            if level in [0, 1]:
                plan = [o.RUN_RIGHT]
                if level == 0:
                    plan += [o.JUMP_RIGHT]
                plan += [o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER]
                return plan
            else:
                return [o.PASS_RIGHT_JUMP_SKULL, o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER]
        elif direction == 'right':
            if level in [0, 1]:
                plan = [o.DOWN_LADDER, o.RUN_RIGHT]
                if level == 0:
                    plan += [o.JUMP_RIGHT, o.RUN_RIGHT]
                plan += [o.RUN_RIGHT]
                return plan
            elif level == 2:
                return [o.DOWN_LADDER, o.PASS_RIGHT_JUMP_SKULL, o.RUN_RIGHT, o.RUN_RIGHT]
        elif direction == 'down':
            if level in [0, 1]:
                plan = [o.RUN_LEFT]
            if level == 2:
                plan = [o.WAIT_JUMP_SKULL_TOWARDS, o.PASS_LEFT_JUMP_SKULL, o.RUN_LEFT]
            if level == 0:
                plan += [o.JUMP_LEFT, o.RUN_LEFT]
            plan += [o.DOWN_LADDER, o.DOWN_LADDER]
            return plan
        elif direction == 'hammer':
            return [o.UP_LADDER, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT, o.DOWN_LADDER, o.DOWN_LADDER]

class Room05:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            plan = [o.UP_LADDER, o.RUN_RIGHT, o.JUMP, o.UP_ROPE]
            if level == 1:
                plan += [o.WAIT_SKULL_AWAY, o.WAIT_SKULL_TOWARDS]
            plan += [
                o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.UP_ROPE,
                o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP, o.RUN_LEFT, o.JUMP_LEFT,
                o.RUN_LEFT, o.DOWN_ROPE
            ]
            if level == 0:
                plan += [o.WAIT_SKULL_AWAY]
            plan += [
                o.WAIT_SKULL_TOWARDS, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_RIGHT, o.RUN_RIGHT,
                o.JUMP_RIGHT, o.DOWN_ROPE, o.DROP_ROPE, o.RUN_LEFT, o.DOWN_LADDER, o.DOWN_LADDER
            ]
            return plan

class Room12:
    @classmethod
    def go(cls, direction, level):
        run_op = {
            'right': o.RUN_RIGHT,
            'left': o.RUN_LEFT,
        }[direction]
        plan = [run_op]
        if level == 0 or (level == 1 and direction == 'left') or (level == 2):
            plan += [o.WAIT_LASER_DISAPPEAR]
        plan += [o.WAIT_LASER_APPEAR, o.WAIT_LASER_DISAPPEAR, run_op] * 4 + [run_op]
        return plan

class Room13:
    @classmethod
    def go(cls, direction, level):
        if direction == 'up':
            plan = [o.RUN_RIGHT]
            if level in [0, 1]:
                plan += [o.JUMP_RIGHT]
            elif level == 2:
                plan += [o.PASS_RIGHT_JUMP_SKULL, o.RUN_RIGHT]
            if level == 0:
                plan += [o.WAIT_SPIDER_TOWARDS, o.RUN_LEFT]
            elif level == 1:
                plan += [o.RUN_RIGHT]
            plan += [o.UP_LADDER, o.UP_LADDER]
            return plan
        elif direction == 'right':
            plan = [o.DOWN_LADDER, o.RUN_RIGHT]
            if level == 0:
                plan += [o.CHARGE_RIGHT]
            elif level == 1:
                plan += [o.JUMP_RIGHT]
            elif level == 2:
                plan += [o.PASS_RIGHT_JUMP_SKULL]
            plan += [o.RUN_RIGHT, o.RUN_RIGHT]
            return plan
        elif direction == 'left':
            plan = [o.UP_LADDER, o.RUN_LEFT]
            if level == 1:
                plan += [o.JUMP_LEFT, o.RUN_LEFT]
            if level == 2:
                plan += [o.PASS_LEFT_JUMP_SKULL, o.RUN_LEFT]
            plan += [o.RUN_LEFT]
            return plan

class Room07:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            plan = [o.UP_LADDER, o.RUN_RIGHT]
            if level == 1:
                plan += [o.WAIT_LASER_APPEAR]
            plan += [
                o.WAIT_LASER_DISAPPEAR, o.RUN_RIGHT, o.JUMP, o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT,
                o.RUN_LEFT, o.RUN_LEFT, o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT, o.WAIT_LASER_APPEAR,
                o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT, o.RUN_LEFT
            ]
            return plan
        elif direction == 'down':
            if level in [0, 1]:
                return [
                    o.RUN_RIGHT, o.WAIT_LASER_DISAPPEAR, o.RUN_RIGHT, o.WAIT_LASER_APPEAR,
                    o.WAIT_LASER_DISAPPEAR, o.RUN_RIGHT, o.DOWN_LADDER, o.DOWN_LADDER
                ]
            elif level == 2:
                return [
                    o.UP_LADDER, o.RUN_RIGHT, o.WAIT_LASER_APPEAR, o.WAIT_LASER_DISAPPEAR,
                    o.RUN_RIGHT, o.JUMP, o.WAIT_LASER_DISAPPEAR, o.RUN_LEFT, o.RUN_LEFT,
                    o.DOWN_LADDER, o.DOWN_LADDER
                ]

class Room06:
    @classmethod
    def go(cls, direction, level):
        if direction == 'right':
            if level == 0:
                return [o.RUN_LEFT, o.RUN_LEFT, o.JUMP, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT]
            elif level == 1:
                return [o.DOWN_LADDER, o.RUN_RIGHT, o.RUN_RIGHT]
        if direction == 'up':
            return [o.RUN_LEFT, o.UP_LADDER, o.UP_LADDER]

class Room02:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            if level == 1:
                return [o.UP_LADDER, o.RUN_RIGHT, o.JUMP, o.RUN_LEFT, o.DOWN_LADDER, o.DOWN_LADDER]

class Room14:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            plan = [o.RUN_RIGHT, o.JUMP_RIGHT]
            if level in [0, 2]:
                plan += [o.JUMP_RIGHT, o.JUMP_LEFT]
            elif level == 1:
                plan += [o.UP_ROPE, o.RUN_RIGHT, o.JUMP, o.RUN_LEFT]
            plan += [o.DOWN_ROPE, o.DROP_ROPE, o.RUN_RIGHT, o.DOWN_LADDER, o.DOWN_LADDER]
            return plan

class Room22:
    @classmethod
    def go(cls, direction, level):
        if direction == 'right':
            return [
                o.DOWN_LADDER, o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR, o.DOWN_LADDER,
                o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT, o.RUN_RIGHT
            ]
        elif direction == 'left':
            plan = []
            if level in [0, 1]:
                plan = [
                    o.RUN_LEFT, o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR, o.RUN_LEFT,
                    o.RUN_LEFT, o.RUN_LEFT
                ]
                if level == 0:
                    plan += [o.RUN_LEFT, o.JUMP_LEFT]
                elif level == 1:
                    plan += [o.CHARGE_LEFT, o.RUN_LEFT, o.RUN_LEFT]
                plan += [o.RUN_LEFT, o.RUN_LEFT]
            elif level == 2:
                plan += [
                    o.DOWN_LADDER, o.DOWN_LADDER, o.RUN_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT,
                    o.RUN_LEFT
                ]
            return plan

class Room23:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            plan = [o.RUN_RIGHT, o.JUMP, o.RUN_RIGHT, o.JUMP]
            if level == 0:
                plan += [o.RUN_RIGHT, o.JUMP]
            plan += [o.RUN_LEFT, o.RUN_LEFT]
            return plan

class Room21:
    @classmethod
    def go(cls, direction, level):
        if direction == 'up':
            plan = [o.RUN_LEFT]
            if level == 0:
                plan += [o.JUMP_LEFT, o.WAIT_SPIDER_TOWARDS]
            elif level == 1:
                plan += [o.RUN_LEFT, o.JUMP]
            elif level == 2:
                plan += [o.JUMP_LEFT, o.RUN_LEFT, o.UP_LADDER, o.UP_LADDER]
                return plan
            plan += [o.RUN_RIGHT, o.UP_LADDER, o.UP_LADDER]
            return plan

class Room19:
    @classmethod
    def go(cls, direction, level):
        if direction == 'right':
            return [o.DOWN_LADDER, o.RUN_RIGHT, o.RUN_RIGHT]
        elif direction == 'left':
            if level == 0:
                plan = [o.RUN_LEFT, o.RUN_LEFT, o.JUMP, o.RUN_LEFT, o.RUN_LEFT]
            elif level == 1:
                plan = [
                    o.DOWN_LADDER, o.RUN_LEFT, o.CHARGE_LEFT, o.RUN_LEFT, o.CHARGE_LEFT,
                    o.RUN_LEFT, o.RUN_LEFT
                ]
            elif level == 2:
                plan = [o.WAIT_SPIDER_TOWARDS, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT, o.RUN_LEFT]
            return plan
        elif direction == 'up':
            return [o.RUN_LEFT, o.UP_LADDER, o.UP_LADDER]

class Room20:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            plan = [
                o.RUN_RIGHT, o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR, o.RUN_RIGHT,
                o.RUN_RIGHT
            ]
            if level in [0, 1]:
                plan += [o.JUMP_RIGHT, o.RUN_RIGHT]
            elif level == 2:
                plan += [o.RUN_RIGHT, o.RUN_RIGHT, o.JUMP, o.RUN_LEFT, o.WAIT_BRIDGE_DISAPPEAR]
            if level == 0:  # grab right gem
                plan += [o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP, o.RUN_LEFT, o.WAIT_BRIDGE_DISAPPEAR]
            elif level == 1:  # skip middle gem
                plan += [o.RUN_RIGHT, o.JUMP_RIGHT]
            plan += [o.WAIT_BRIDGE_APPEAR, o.RUN_LEFT, o.RUN_LEFT]
            if level in [0, 2]:
                plan += [o.RUN_LEFT]
            elif level == 1:  #grab middle gem
                plan += [o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_LEFT]
            plan += [o.RUN_LEFT, o.RUN_LEFT]
            return plan

class Room18:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            plan = []
            if level in [0, 1]:
                plan += [o.RUN_LEFT]
            plan += [o.WAIT_BRIDGE_DISAPPEAR, o.WAIT_BRIDGE_APPEAR]
            if level == 0:
                plan += [o.RUN_LEFT, o.CHARGE_LEFT, o.RUN_LEFT]
            if level == 1:
                plan += [o.RUN_LEFT]
            if level == 2:
                plan += [
                    o.WAIT_BRIDGE_DISAPPEAR, o.RUN_LEFT, o.WAIT_BRIDGE_APPEAR, o.RUN_LEFT,
                    o.RUN_LEFT, o.JUMP_LEFT
                ]
            plan += [o.RUN_LEFT, o.RUN_LEFT, o.RUN_LEFT, o.RUN_LEFT]
            return plan

class Room17:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            return [o.RUN_LEFT, o.RUN_LEFT]

class Room16:
    @classmethod
    def go(cls, direction, level):
        if direction == 'left':
            return [o.RUN_LEFT, o.RUN_LEFT]

class Room15:
    @classmethod
    def go(cls, direction, level):
        if direction == 'down':
            if level == 0:
                return [
                    o.RUN_LEFT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_RIGHT,
                    o.RUN_RIGHT, o.JUMP_LEFT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_LEFT, o.RUN_LEFT,
                    o.JUMP_RIGHT, o.RUN_RIGHT, o.WAIT_LEVEL
                ]
            elif level == 1:
                return [
                    o.RUN_LEFT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_LEFT, o.JUMP_LEFT, o.RUN_LEFT,
                    o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_RIGHT, o.JUMP_LEFT,
                    o.RUN_LEFT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_LEFT, o.RUN_LEFT, o.JUMP_RIGHT,
                    o.RUN_RIGHT, o.WAIT_LEVEL
                ]
            elif level == 2:
                return [
                    o.RUN_LEFT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_RIGHT, o.JUMP_RIGHT, o.JUMP_LEFT,
                    o.RUN_LEFT, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP_RIGHT, o.JUMP_LEFT, o.RUN_LEFT,
                    o.JUMP, o.JUMP_RIGHT, o.RUN_RIGHT, o.JUMP, o.JUMP_LEFT, o.RUN_LEFT,
                    o.WAIT_LEVEL
                ]
        if direction == 'skip':
            return [o.RUN_LEFT, o.RUN_RIGHT] * 2 + [o.RUN_LEFT, o.WAIT_LEVEL]

# yapf: disable
plan_level0 = [(room, direction, 0) for (room, direction) in [
    (Room01, 'left'),
    (Room00, 'down'),
    (Room04, 'left'),
    (Room03, 'down'),
    (Room09, 'left'),
    (Room08, 'right'),
    (Room09, 'up'),
    (Room03, 'right'),
    (Room04, 'down'),
    (Room10, 'right'),
    (Room11, 'up'),
    (Room05, 'down'),
    (Room11, 'right'),
    (Room12, 'right'),
    (Room13, 'up'),
    (Room07, 'left'),
    (Room06, 'right'),
    (Room07, 'down'),
    (Room13, 'right'),
    (Room14, 'down'),
    (Room22, 'right'),
    (Room23, 'left'),
    (Room22, 'left'),
    (Room21, 'up'),
    (Room13, 'left'),
    (Room12, 'left'),
    (Room11, 'down'),
    (Room19, 'right'),
    (Room20, 'left'),
    (Room19, 'left'),
    (Room18, 'left'),
    (Room17, 'left'),
    (Room16, 'left'),
    (Room15, 'down'),
]]
plan_level1 = [(room, direction, 1) for (room, direction) in [
    (Room01, 'left'),
    (Room00, 'down'),
    (Room04, 'left'),
    (Room03, 'down'),
    (Room09, 'left'),
    (Room08, 'right'),
    (Room09, 'up'),
    (Room03, 'right'),
    (Room04, 'down'),
    (Room10, 'right'),
    (Room11, 'up'),
    (Room05, 'down'),
    (Room11, 'right'),
    (Room12, 'right'),
    (Room13, 'up'),
    (Room07, 'left'),
    (Room06, 'up'),
    (Room02, 'down'),
    (Room06, 'right'),
    (Room07, 'down'),
    (Room13, 'right'),
    (Room14, 'down'),
    (Room22, 'right'),
    (Room23, 'left'),
    (Room22, 'left'),
    (Room21, 'up'),
    (Room13, 'left'),
    (Room12, 'left'),
    (Room11, 'down'),
    (Room19, 'right'),
    (Room20, 'left'),
    (Room19, 'up'),
    (Room11, 'hammer'),
    (Room19, 'left'),
    (Room18, 'left'),
    (Room17, 'left'),
    (Room16, 'left'),
    (Room15, 'down'),
]]
plan_level2 = [(room, direction, 2) for (room, direction) in [
    (Room01, 'left'),
    (Room00, 'down'),
    (Room04, 'climb_through'),
    (Room10, 'up'),
    (Room04, 'left'),
    (Room03, 'down'),
    (Room09, 'left'),
    (Room08, 'right'),
    (Room09, 'up'),
    (Room03, 'right'),
    (Room04, 'down'),
    (Room10, 'right'),
    (Room11, 'up'),
    (Room05, 'down'),
    (Room11, 'right'),
    (Room12, 'right'),
    (Room13, 'up'),
    (Room07, 'down'),
    (Room13, 'right'),
    (Room14, 'down'),
    (Room22, 'left'),
    (Room21, 'up'),
    (Room13, 'left'),
    (Room12, 'left'),
    (Room11, 'down'),
    (Room19, 'right'),
    (Room20, 'left'),
    (Room19, 'left'),
    (Room18, 'left'),
    (Room17, 'left'),
    (Room16, 'left'),
    (Room15, 'down'),
]]
# yapf: enable

plan_level2_loop = plan_level2[:-1] + [(Room15, 'skip', 2)]

plan = [
    op
    for room, direction, level in (plan_level0 + plan_level1 + plan_level2 + plan_level2_loop * 2)
    for op in room.go(direction, level)
]

# When we generate random behavior branching off from the original plan, we always skip room 15 (the treasure room) because it behaves differently.
plan_skip_15 = [
    op
    for room, direction, level in (plan_level0 + plan_level1 + plan_level2 + plan_level2_loop * 2)
    for op in (room.go('skip', level) if room == Room15 else room.go(direction, level))
]
