import imageio
import os
import pickle


def saveData(path, images, states, experiences):
    os.makedirs(path, exist_ok=True)
    saveImages(images, path)
    saveStates(states, path)
    saveExperiences(experiences, path)


def loadData(path):
    assert os.path.exists(path)
    images = loadImages(path)
    states = loadStates(path)
    experiences = loadExperiences(path)
    return images, states, experiences


def saveImages(imgs, path, name='images.bsdf'):
    print(path)
    filename = os.path.join(path, name) if path != '' else name
    imageio.mimwrite(filename, imgs)


def loadImages(path='', name='images.bsdf'):
    filename = os.path.join(path, name) if path != '' else name
    images = imageio.mimread(filename, memtest=False)
    return images


def loadImage(path, idx):
    name = 't_{:05d}.png'.format(idx)
    filename = os.path.join(path, name) if path != '' else name
    img = imageio.imread(filename)
    return img


def saveObject(obj, path, name):
    filename = os.path.join(path, name)
    with open(filename, 'wb') as f:
        pickle.dump(obj, f, pickle.HIGHEST_PROTOCOL)


def loadObject(path, name):
    filename = os.path.join(path, name)
    with open(filename, 'rb') as f:
        return pickle.load(f)


def saveExperiences(experiences, path, name='experiences.pkl'):
    return saveObject(experiences, path, name)


def loadExperiences(path, name='experiences.pkl'):
    return loadObject(path, name)


def saveStates(states, path, name='states.pkl'):
    return saveObject(states, path, name)


def loadStates(path, name='states.pkl'):
    return loadObject(path, name)


def saveMP4(path, images):
    dir = os.path.dirname(path)
    os.makedirs(dir, exist_ok=True)
    imageio.mimwrite(path, images, fps=60)


def saveImage(path, img):
    # Note: this is not the inverse of loadImage
    imageio.imwrite(path, img)
