#!/bin/bash

#获取参数
USE_NOHUP=$1
EXPERIMENTS=$2

#获取当前时间戳
TIMESTAMP=$(date +%m%d%H%M)

#读取配置文件
CONFIG_FILE="configs/text_encode_config.json"

#解析project rootpath
PROJECT_ROOTPATH=$(jq -r '.project_rootpath' "$CONFIG_FILE")
LOG_DIR="$PROJECT_ROOTPATH/log/text_encode_log/encode_log_${TIMESTAMP}"
mkdir -p "$LOG_DIR"

#运行所有实验
for EXP in $EXPERIMENTS; do
  MODEL_ID=$(echo "$EXP" | cut -d '_' -f 1)
  DATASET_ID=$(echo "$EXP" | cut -d '_' -f 2)

  MODEL_NAME=$(jq -r ".models[\"$MODEL_ID\"].name" "$CONFIG_FILE")
  SCRIPT_NAME=$(jq -r ".models[\"$MODEL_ID\"].script" "$CONFIG_FILE")
  DATASET_NAME=$(jq -r ".datasets[\"$DATASET_ID\"].name" "$CONFIG_FILE")

  LOG_FILE="${LOG_DIR}/${MODEL_NAME}_${DATASET_NAME}.log"
  echo "Running experiment: Model=${MODEL_NAME}, Dataset=${DATASET_NAME}"
  CMD="python ${PROJECT_ROOTPATH}/${SCRIPT_NAME} --model_name $MODEL_NAME --dataset_name $DATASET_NAME"
  if [ "$USE_NOHUP" = "true" ]; then
    echo "Using nohup, log to ${LOG_FILE}"
    nohup bash -c "$CMD" > "$LOG_FILE" 2>&1 &
    PID=$!
    echo "PID: $PID"
    wait $PID
  else
    bash -c $CMD
  fi
done

echo "All experiments finished."
