#!/bin/bash

#读取配置文件
CONFIG_FILE="configs/transform_config.json"
SCRIPT_FILE="transform/cluster_transform.py"

#运行所有实验
for MODEL_NAME in $(jq -r ".models[]" "$CONFIG_FILE"); do
  for DATASET_NAME in $(jq -r ".datasets[]" "$CONFIG_FILE"); do
    echo "Feature Transform: Model=${MODEL_NAME}, Dataset=${DATASET_NAME}"
    CMD="python ${SCRIPT_FILE} --model_name $MODEL_NAME --dataset_name $DATASET_NAME"
    $CMD
  done
done

echo "All transform experiments finished."
