import jsonlines
import h5py

def load_jsonl(path):
    data = []
    with jsonlines.open(path) as reader:
        for obj in reader:
            data.append(obj)
    return data


def save_to_hdf5(file_path, ids, vectors):
    with h5py.File(file_path, "w") as h5f:
        h5f.create_dataset("ids", data=[id.encode() for id in ids],
                           dtype=h5py.string_dtype())
        h5f.create_dataset("vectors", data=vectors, dtype="float32")