# SphereNet

This is an implementation for Spherical Message Passing for 3D Molecular Graphs.



## Table of Contents

- [SphereNet](#spherenet)
  - [Table of Contents](#table-of-contents)
  - [Setup](#setup)
  - [Datasets](#datasets)
    - [QM9](#qm9)
    - [MD17](#md17)
    - [OC20](#oc20)
  - [Usage](#usage)
  - [Acknowledgements](#acknowledgements)


## Setup

To install the conda virtual environment `spherenet`:
```shell script
$ bash setup.sh
```
Note that we use CUDA 10.1 in this project. If you have other CUDA versions, you should install the PyTorch and cudatoolkit compatible with your CUDA. Note that the versions of PyTorch and PyTorch Geometric should be compatible. It would be easy to install PyTorch Geometric by following the [installation instruction](https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html#).


## Datasets
Download data to the `spherenet/datasets` folder.
### QM9
Download from https://github.com/klicperajo/dimenet/blob/master/data/qm9_eV.npz.
### MD17
Download from http://quantum-machine.org/gdml/#datasets.
Note that for Benzene dataset, we used the 2017 version.
### OC20
The dataset can be downloaded from https://github.com/Open-Catalyst-Project/ocp/blob/master/DATASET.md.

For the sake of simplicity and fair comparison, we use the official [ocp-models](https://github.com/Open-Catalyst-Project/ocp) for training and evaluating on OC20 dataset.

In order to use our implementations, one needs to put the model file and the other used modules into their code. For example, 

- Put `spherenet.py` in `ocp/ocpmodels/models/`.
- Put `features.py` and `utils.py`  in `ocp/ocpmodels/utils/`. 

One also needs to adapt the import paths for the used modules accordingly.


## Usage
When using the default hyperparameters:
```shell script
CUDA_VISIBLE_DEVICES=${your_gpu_id} python main.py --save_dir $save_dir --dataset $dataset --target $target --batch_size $batch_size --epochs $epochs 
```


## Acknowledgements
Our implementation is based on [DimeNet](https://github.com/klicperajo/dimenet) and [Models in PyTorch Geometric](https://github.com/rusty1s/pytorch_geometric/blob/master/torch_geometric/nn/models/dimenet.py). Thanks a lot for their awesome work.