# Train NeuralMark
python classifier.py --seed 42 --epochs 200
python classifier.py --seed 42 --epochs 200 --dataset cifar100
python classifier.py --seed 42 --epochs 200 --dataset caltech101
python classifier.py --seed 42 --epochs 200 --dataset caltech256
python classifier.py --seed 42 --epochs 200 --dataset imagenet
# Finetune Attack
python classifier.py --seed 42 --epochs 100 --action finetune --dataset cifar100 --pretrained-path logs/resnet_cifar10_train/1/models/final.pth --lr 0.001
python classifier.py --seed 42 --epochs 100 --action finetune --pretrained-path logs/resnet_cifar100_train/1/models/final.pth --lr 0.001
python classifier.py --seed 42 --epochs 100 --action finetune --dataset caltech256 --pretrained-path logs/resnet_caltech101_train/1/models/final.pth --lr 0.001
python classifier.py --seed 42 --epochs 100 --action finetune --dataset caltech101 --pretrained-path logs/resnet_caltech256_train/1/models/final.pth --lr 0.001
# Pruning Attack
python classifier.py --action pruning --seed 42 --epochs 1 --pruning-rate 0.2 --pretrained-path logs/resnet_cifar10_train/1/models/final.pth
python classifier.py --action pruning --seed 42 --epochs 1 --pruning-rate 0.2 --pretrained-path logs/resnet_cifar100_train/1/models/final.pth --dataset cifar100
python classifier.py --action pruning --seed 42 --epochs 1 --pruning-rate 0.2 --pretrained-path logs/resnet_caltech101_train/1/models/final.pth --dataset caltech101
python classifier.py --action pruning --seed 42 --epochs 1 --pruning-rate 0.2 --pretrained-path logs/resnet_caltech256_train/1/models/final.pth --dataset caltech256
# Forging Attack
python classifier.py --action forging --epochs 1 --watermark-seed 110 --pretrained-path logs/resnet_cifar10_finetune/1/models/final.pth
python classifier.py --action forging --epochs 1 --watermark-seed 110 --pretrained-path logs/resnet_cifar10_pruning/1/models/final.pth
python classifier.py --action forging --epochs 1 --watermark-seed 110 --pretrained-path logs/resnet_cifar100_finetune/1/models/final.pth --dataset cifar100
python classifier.py --action forging --epochs 1 --watermark-seed 110 --pretrained-path logs/resnet_cifar100_pruning/1/models/final.pth --dataset cifar100
# Overwrite Attack
python classifier.py --seed 42 --epochs 100 --action overwrite --dataset cifar100 --pretrained-path logs/resnet_cifar10_train/1/models/final.pth --lr 0.001 --watermark-seed 5 --lambda 1
python classifier.py --seed 42 --epochs 100 --action overwrite --pretrained-path logs/resnet_cifar100_train/1/models/final.pth --lr 0.001 --watermark-seed 5 --lambda 1
python classifier.py --seed 42 --epochs 100 --action overwrite --dataset caltech256 --watermark-std 1 --pretrained-path logs/resnet_caltech101_train/1/models/final.pth --lr 0.001 --watermark-seed 5 --lambda 1
python classifier.py --seed 42 --epochs 100 --action overwrite --dataset caltech101 --watermark-std 1 --pretrained-path logs/resnet_caltech256_train/1/models/final.pth --lr 0.001 --watermark-seed 5 --lambda 1