from refinement.classifier import ScenarioClassifier
from refinement.refiner import PromptRefiner
from refinement.scenarios import Scenario
from verification.verify import verify
from config import CFG_PR, CFG_CHUNK

def run_example():
    # A realistic user-style original prompt (no duration/slow-mo directives)
    # original = "A cat is sleeping on a sofa in the living room."
    # original = "A cat plays chess with a dog while a parrot referees in a steampunk library."
    # original = "Hope dances in a field of forgotten dreams."
    # original = "A glass falling and shattering on the ground."
    original = "A tranquil tableau of alley."

    # From classification to refinement
    clf = ScenarioClassifier()
    pred = clf.predict(original)
    print(f"[Scenario] {pred.label} (p={pred.score:.2f}) | source={pred.source} | stats={pred.stats}")

    # Map label string back to Scenario enum
    scenario = Scenario.NORMAL
    for s in Scenario:
        # print('run_instance.py line 20 s.value: ', s.value)
        if s.value == pred.label:
            scenario = s
            break

    # print('run_instance.py line 25 scenario: ', scenario)   # Scenario.SPATIAL

    # If gen_model is provided, it will generate a refined prompt locally.
    # Otherwise we return a meta-prompt, which you can send to an external LLM.
    refiner = PromptRefiner(use_refine_llm=CFG_PR.use_refine_llm)
    refined_prompt = refiner.refine(scenario, original)

    print("run_instance.py line 32 refined_prompt: ", refined_prompt)

    # Verification
    # Use word-level chunking and auto language detection
    chunk_cfg = CFG_CHUNK

    verify_results = verify(original_prompt=original, expanded_prompt=refined_prompt, chunk_cfg=chunk_cfg)
    print("\n[Verification Results]\n", verify_results)

if __name__ == "__main__":
    run_example()