from typing import Dict

def priority_rule(s1: Dict[str, float], s2: Dict[str, float]) -> str:
    """
    Conservative arbitration between two TE models:
    - Contradiction has highest priority
    - If any entailment exists: strong entailment if both agree, else weak entailment
    - Otherwise neutral
    """
    def top_label(sc: Dict[str, float]) -> str:
        return max(sc.items(), key=lambda kv: kv[1])[0]

    l1, l2 = top_label(s1), top_label(s2)
    if "contradiction" in {l1, l2}:
        return "CONTRADICTION"
    if "entailment" in {l1, l2}:
        return "ENTAILMENT" if (l1 == l2 == "entailment") else "WEAK_ENTAIL"
    return "NEUTRAL"