from verification.atomize import extract_atoms
from verification.chunking import chunk_text, detect_lang
from .te_models import DualTE
from .priority import priority_rule

def reverse_entailment_diagnostics(expanded_prompt: str, original_prompt: str, te: DualTE, chunk_mode="word", k: int = 3):
    """
    Optional reverse-entailment diagnostic:
    - Atomize the refined prompt, then check whether these atoms are entailed by the original prompt.
    - This identifies over-specification / hallucinated constraints.
    - For analysis only; does NOT participate in the main decision.
    """
    B = extract_atoms(expanded_prompt)   # atoms from refined prompt
    lang = detect_lang(original_prompt)
    A_chunks = chunk_text(original_prompt, mode=chunk_mode, lang=lang)

    results = []
    for b in B:
        labels = []
        for cj in A_chunks:  # simple loop; you may add retrieval if original is long
            s1, s2 = te.infer(premise=cj, hypothesis=b)
            labels.append(priority_rule(s1, s2))
        if "ENTAILMENT" in labels:
            final = "ENTAILMENT"
        elif "CONTRADICTION" in labels:
            final = "CONTRADICTION"
        else:
            final = "NEUTRAL"
        results.append({"b": b, "labels": labels, "final": final})
    return results
