## Quick Start
### 1. Install [Singularity](https://sylabs.io/guides/3.5/user-guide/introduction.html) (optional)
If you don't want to install Singularity, make sure that you have all dependecies from Singularity.def (python3, numpy, pytorch, etc.)

a. Pull an image 
````
singularity pull library://k3nfalt/default/python_ml:sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745
````
b. Open a shell console of the image
````
singularity shell --nv ~/python_ml_sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745.sif
````
### 2. Prepare scripts for experiments

````
mkdir ~/exepriments/
````

````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/marina_p/config_libsvm.py --dataset mnist --experiments_name EXPERIMENTS_NAME --num_nodes_list 100 --step_size_range -4 10 --number_of_iterations 20000 --algorithms m3_perm_nat_ind dcgd_ef21_primal_rand_nat_rand_nat --function auto_encoder --cpus_per_task 2 --time 10 --ef21_init_with_gradients --point_initializer xavier_normal --split_with_controling_homogeneity 0.0 --reg_paramterer 0.001 --number_of_seeds 5
````

````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/marina_p/config_libsvm.py --dataset mnist --experiments_name EXPERIMENTS_NAME --num_nodes_list 100 --step_size_range -4 2 --number_of_seeds 1 --number_of_iterations 20000 --algorithms gradient_descent m3_perm_with_nat_rand_with_nat --function auto_encoder --cpus_per_task 2 --time 10 --ef21_init_with_gradients --point_initializer xavier_normal --split_with_controling_homogeneity 0.0 --reg_paramterer 0.001 --number_of_seeds 5
````

````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/marina_p/config_libsvm.py --dataset mnist --experiments_name EXPERIMENTS_NAME --num_nodes_list 100 --step_size_range -4 2 --number_of_seeds 1 --number_of_iterations 20000 --algorithms core --function auto_encoder --cpus_per_task 2 --time 10 --ef21_init_with_gradients --point_initializer xavier_normal --split_with_controling_homogeneity 0.0 --reg_paramterer 0.001 --number_of_seeds 5
````

### 3. Execute scripts
````
sh ~/exepriments/EXPERIMENTS_NAME/singularity_*.sh
````

