TASKS=("multi_turn_prefix_suffix" "multi_turn_kv" "multi_turn_mf" "multi_turn_qa_chn" "multi_turn_qa_eng" "multi_turn_choice_eng" "multi_turn_summary" "multi_turn_vt" "multi_turn_repoqa" "multi_turn_many_shot" "multi_turn_summary_with_needles" "multi_turn_repoqa_and_kv")

MODE=$5
if [ "$MODE" == "scdq" ]; then
    MODE="--same_context_different_query"
else
    MODE=""
fi

for task in ${TASKS[@]}; do
echo $task
python SCBench/run_scbench.py \
    --task $task \
    --model_name_or_path $1 \
    --data_dir ./data \
    --output_dir ./results \
    --max_seq_length 131_072 \
    --num_eval_examples $2 \
    --starting_layer 0 \
    --attn_type $3 \
    --trust_remote_code \
    --tensor_parallel_size $4 \
    --kv_type $6 \
    --use_chat_template ${MODE}
done

# VLLM_ALLOW_LONG_MAX_MODEL_LEN=1 CUDA_VISIBLE_DEVICES=0 VLLM_WORKER_MULTIPROC_METHOD=spawn bash run_scbench.sh meta-llama/Meta-Llama-3.1-8B-Instruct -1 dense 8 scdq snapkv