/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.generic;

import java.util.Random;
import org.ejml.data.Matrix64F;

public class GenericMatrixOps {
    public static boolean isEquivalent(Matrix64F a, Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < a.numCols; ++j) {
                double diff = Math.abs(a.get(i, j) - b.get(i, j));
                if (!(diff > tol)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(Matrix64F a, double tol) {
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < a.numCols; ++j) {
                if (!(i == j ? Math.abs(a.get(i, j) - 1.0) > tol : Math.abs(a.get(i, j)) > tol)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquivalentTriangle(boolean upper, Matrix64F a, Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (upper) {
            for (int i = 0; i < a.numRows; ++i) {
                for (int j = i; j < a.numCols; ++j) {
                    double diff = Math.abs(a.get(i, j) - b.get(i, j));
                    if (!(diff > tol)) continue;
                    return false;
                }
            }
        } else {
            for (int j = 0; j < a.numCols; ++j) {
                for (int i = j; i < a.numRows; ++i) {
                    double diff = Math.abs(a.get(i, j) - b.get(i, j));
                    if (!(diff > tol)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void copy(Matrix64F from, Matrix64F to) {
        int numCols = from.getNumCols();
        int numRows = from.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                to.set(i, j, from.get(i, j));
            }
        }
    }

    public static void setRandom(Matrix64F a, double min, double max, Random rand) {
        for (int i = 0; i < a.numRows; ++i) {
            for (int j = 0; j < a.numCols; ++j) {
                double val = rand.nextDouble() * (max - min) + min;
                a.set(i, j, val);
            }
        }
    }
}

