function completed = nn_neuron_merge_main()
% nn_neuron_merge_main - runs all scripts accompanying the
% "Fully Automatic Neural Network Reduction for Formal Verification" Paper
%
% results and plots will be saved to ./results
%
% Syntax:
%    completed = nn_neuron_merge_main()
%
% Inputs:
%    -
%
% Outputs:
%    completed - boolean
%
% Reference:
%
% Author:       anonymous
% Written:      18-January-2024
% Last update:  ---
% Last revision:---

%------------- BEGIN CODE --------------

% STARTUP -----------------------------------------------------------------
rng(1)
warning off

basepath = "./results";
mkdir(basepath)
plotpath = sprintf("%s/plots", basepath);
mkdir(plotpath)
evalpath = sprintf("%s/evaluation", basepath);
mkdir(evalpath)

% for smooth images
set(0, 'defaultFigureRenderer', 'painters')

resultstxt = sprintf("%s/results.txt", basepath);
delete(resultstxt)
diary(resultstxt)
disp("--------------------------------------------------------")
disp("Transactions of Machine Learning Research")
disp("Paper: Fully Automatic Neural Network Reduction for Formal Verification")
fprintf("Date: %s\n", datestr(datetime()))
disp(CORAVERSION)
disp("--------------------------------------------------------")
disp(" ")

% RUN SCRIPTS ----------------------------------------------------------
scrips = {; ...
    % main evaluation
    @() nn_neuron_merge_vnn_eran_eval_all(evalpath), "evaluation_run";
    @() nn_neuron_merge_create_eval_plots(evalpath), "evaluation_plots";
    % other evaluations
    @nn_neuron_merge_acasxu, "acasxu";
    @nn_neuron_merge_mnist_automatic_reduction_comparison, "mnist_automatic_reduction_comparison";
    @nn_neuron_merge_closed_loop_QUAD, "closed_loop";
    
    };

n = size(scrips, 1);
fprintf("Running %d scripts.. \n", n);
disp(" ")

for i = 1:n
    disp("--------------------------------------------------------")
    script = scrips{i, 1};
    name = scrips{i, 2};

    try
        % run script
        fprintf("Running '%s' ...\n", name)
        script();

        disp(" ")
        fprintf("'%s' was run successfully!\n", name)
        fprintf("Saving plots to '%s'..\n", plotpath)

        % save plots
        h = findobj('type', 'figure');
        m = length(h);

        for j = 1:m
            savefig(sprintf("%s/%s_%d.%s", plotpath, name, j, 'fig'));
            saveas(gcf, sprintf("%s/%s_%d.%s", plotpath, name, j, 'png'));
            saveas(gcf, sprintf("%s/%s_%d.%s", plotpath, name, j, 'eps'), 'epsc');
            close(gcf)
        end

    catch ME
        % error handling
        disp(" ")
        fprintf("An ERROR occured during execution of '%s':\n", name);
        disp(ME.getReport())
        disp("Continuing with next script..")
    end

    disp(" ")
end

% -------------------------------------------------------------------------
disp("--------------------------------------------------------")
disp(" ")
completed = 1;
disp("Completed!")
fprintf("Date: %s\n", datestr(datetime()))
diary off;
end
