function [res] = testnn_neuralNetwork_computeReducedNetwork()
% testnn_neuralNetwork_computeReducedNetwork - tests the
%    computeReducedNetwork function using a larger network
%
%
% Syntax:
%    res = testnn_neuralNetwork_computeReducedNetwork()
%
% Inputs:
%    -
%
% Outputs:
%    res - boolean
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Tobias Ladner
% Written:       09-January-2022
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% from VNN'21 eran benchmark
modelfile = "ffnnSIGMOID__Point_6x200.onnx";
nn = neuralNetwork.readONNXNetwork(modelfile, false, 'BSSC');


% get input image
% [XTest YTest ~] = digitTest4DArrayData;
idx = 2790;
X = [0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0.0157 0.2314 0.4510 0.3490 0.2510 0.1529 0.0510 0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0.1098 0.6431 1.0000 1.0000 1.0000 1.0000 1.0000 0.9059 0.8039 0.7059 0.5451 0.2275 0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0.2902 0.8471 0.9490 0.9569 0.9882 1.0000 1.0000 1.0000 1.0000 0.9843 0.6627 0.2078 0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0.5412 0.9804 0.6157 0.6706 0.8314 0.9686 0.9843 0.9294 0.8039 0.5608 0.2000 0.0275 0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0.1412 0.7686 0.8039 0.0667 0      0      0.0353 0.1333 0.2118 0.2275 0.0941 0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0.0118 0.3608 0.8314 0.4745 0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0.0863 0.6235 0.6784 0.2078 0      0      0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0.2588 0.8392 0.6118 0.2706 0.1176 0.0196 0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0.5020 0.9804 1.0000 1.0000 0.9686 0.8549 0.5843 0.2431 0.0275 0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0.1333 0.7529 1.0000 1.0000 1.0000 1.0000 0.9882 0.9333 0.7804 0.4118 0.0275 0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0.1608 0.5451 0.7216 0.8235 0.9294 1.0000 1.0000 1.0000 0.9725 0.7725 0.3059 0.0039 0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0.0314 0.1255 0.3725 0.7294 0.9608 1.0000 0.9490 0.5804 0.0863 0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0.0039 0.0431 0.1922 0.6706 0.9569 1.0000 0.7255 0.2078 0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0.0118 0.3647 0.9137 1.0000 0.8627 0.1765 0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0.0039 0.1412 1.0000 1.0000 0.9451 0.0196 0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0.0196 0.2941 1.0000 0.9804 0.7529 0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0.1529 0.6039 1.0000 0.8941 0.4745 0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0.2902 0.2039 0.0745 0.0235 0.0039 0      0      0      0.1216 0.5412 0.8902 0.9843 0.6431 0.1922 0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0.7804 0.6667 0.4039 0.2314 0.0510 0.0353 0.1529 0.3804 0.6588 0.9294 0.9843 0.7725 0.2157 0.0157 0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0.0824 0.5608 0.8824 0.9686 0.9961 0.9569 0.8627 0.8118 0.8667 0.9922 0.9216 0.6863 0.1843 0.0039 0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0.0118 0.1490 0.4745 0.7451 0.9412 0.9843 0.9569 0.8784 0.7529 0.6118 0.4235 0.1098 0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0.0392 0.1373 0.2235 0.2667 0.2314 0.1098 0.0078 0      0      0      0      0      0      0      0      0      0      0      0      0; ...
     0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0      0];
X = X'; % due to row- vs. column-major in python vs. matlab: https://stackoverflow.com/questions/59793724/reshape-and-indexing-in-matlab-and-python
X = reshape(X, [], 1);
X = double(X);

% use it as center if input set
c = X;
delta = 0.001;
G = eye(length(c)) * delta;
pZ = polyZonotope(c, G);

% compute samples incl critical points
S = mean(nn.calcSensitivity(c), 1);
xs = [; ...
    pZ.randPoint(10) ...
    c + sign(S') * delta ...
    c - sign(S') * delta; ...
    ];
ys = nn.evaluate(xs);

% reduce network
[nn_red Y_red] = nn.computeReducedNetwork(pZ);

% check if points are contained
res = all(zonotope(Y_red).contains(ys));

end

% ------------------------------ END OF CODE ------------------------------
