
function nn_neuron_merge_acasxu

% settings
MAX_RUNS = 10;

% init acasxuinstances
load acasxuinstances.mat acasxuinstances
% idx = randi(size(acasxuinstances,1),1);
idx = 116;

% init results
orgTime = zeros(1,MAX_RUNS);
redTime = zeros(1,MAX_RUNS);

% average over MAX_RUNS
for i=1:MAX_RUNS
    disp("---")
    fprintf("%i/%i:\n\n",i,MAX_RUNS)
    rng(10)
    
    % read network and specifications
    nn = neuralNetwork.readONNXNetwork( ...
        acasxuinstances{idx,1},false,'BCSS');
    nn = nn.getNormalForm(); % normalize network (Def. 2)
    [X0,spec] = vnnlib2cora( ...
        sprintf('./code/data/vnn/acasxu/prop_%i.vnnlib',acasxuinstances{idx,2}));
    X = zonotope(X0{1});
    
    % verify using original network
    disp("Verify original network..")
    tic;
    nn.verify(X,spec,'Verbose',false,'Splits',9);
    orgTime(i) = toc;
    
    % reduce+verify network
    disp("Reduce+verify network..")
    tic;
    nn_red = nn.computeReducedNetwork(X,'Verbose',i==MAX_RUNS,'BucketType','static','BucketTol',0.001);
    nn_red.verify(X,spec,'Verbose',false,'Splits',9);
    redTime(i) = toc;
end

disp("---")
fprintf("Original Network: %.2f\n",mean(orgTime))
fprintf("Reduced Network: %.2f\n",mean(redTime))
