function nn_neuron_merge_create_eval_plots(evaluationPathBase)

    % MNIST
    
    % MNISTFC
    evResults = [
        "static/1.000000e-02/evResult_mnist-net_256x6"
        "static/1.000000e-02/evResult_mnist-net_256x4"
        "static/1.000000e-02/evResult_mnist-net_256x2"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_mnistfc_benchmark.tikz'],14)

    % ERAN

    % (a,b) CROWN comparison
    evResults = {
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.10";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.50";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_1.00";
        % ab CROWN
        {'ab CROWN (GPU)', [3.1852781772613525, 1.9071681499481201, 2.063800573348999, 1.7952072620391846, 1.6034965515136719, 1.5917255878448486, 1.6756105422973633, 2.1734189987182617, 2.154900550842285, 2.078202724456787, 2.1161999702453613, 1.8521809577941895, 1.695425271987915, 1.5874741077423096, 1.9932782649993896, 2.3473284244537354, 2.0318667888641357, 2.22293758392334, 2.157323122024536, 1.5669901371002197, 1.4932518005371094, 1.7585506439208984, 1.607119083404541, 1.2404029369354248, 1.1516518592834473, 1.2586207389831543, 1.5742754936218262, 1.5156581401824951, 1.2508985996246338, 1.1291730403900146, 1.397392988204956, 1.6602997779846191, 1.3642220497131348, 1.2805910110473633, 1.0935547351837158, 1.4234466552734375, 1.2812707424163818, 1.2960569858551025, 1.0967516899108887, 1.0663669109344482, 1.1471116542816162, 1.520106315612793, 3.6463475227355957, 3.438500165939331, 3.0652809143066406, 2.055281400680542, 1.5917608737945557, 1.1745760440826416, 1.131241798400879, 1.3877959251403809, 1.4016268253326416, 1.2919032573699951, 1.2153244018554688, 1.2024877071380615, 1.7213249206542969, 3.1166694164276123, 1.7451412677764893, 1.4279320240020752, 1.2044026851654053, 1.2281537055969238, 1.3150908946990967, 1.1876716613769531, 1.1041784286499023, 1.0906600952148438, 1.0867245197296143, 1.2407796382904053, 1.273911952972412, 1.1275036334991455, 1.0557551383972168, 1.1011583805084229, 1.0818543434143066, 1.2350528240203857, 1.302760124206543, 1.159602165222168, 1.0759894847869873, 1.3648033142089844, 1.8015923500061035, 1.8809833526611328, 1.6441688537597656, 1.8848488330841064, 1.3624353408813477, 1.3284215927124023, 1.2710049152374268, 1.2024805545806885, 1.0123164653778076, 1.0886361598968506, 1.124323844909668, 1.0757582187652588, 0.9288649559020996, 0.9296622276306152, 1.0415258407592773, 1.340444564819336, 1.2788312435150146, 1.095703363418579, 1.1577818393707275, 0.9892401695251465, 0.9144690036773682, 1.1066076755523682, 1.276275634765625]}
        {'ab CROWN (CPU)', [5.086274862289429, 4.542788982391357, 4.98932957649231, 4.891465425491333, 4.574524641036987, 4.905196189880371, 5.531450271606445, 4.3963892459869385, 4.742215871810913, 4.522590160369873, 4.417304754257202, 5.017565965652466, 5.210684776306152, 4.78371524810791, 4.783864736557007, 4.429738521575928, 4.412606239318848, 4.499089956283569, 4.90608549118042, 4.902353048324585, 4.879870414733887, 4.472876310348511, 4.884420156478882, 4.785385608673096, 4.454481363296509, 4.691406488418579, 4.718698501586914, 4.526122808456421, 4.549847364425659, 4.774450063705444, 4.582621335983276, 4.94381856918335, 4.752230644226074, 4.636072635650635, 4.577410697937012, 4.959552764892578, 4.87860894203186, 4.532269477844238, 4.699352025985718, 4.595662593841553, 4.467115879058838, 4.540966749191284, 4.954770565032959, 4.687898635864258, 5.59090256690979, 4.365819454193115, 4.934525012969971, 4.323164224624634, 4.19623064994812, 4.540220737457275, 5.0481977462768555, 4.5886619091033936, 5.139101028442383, 4.180497646331787, 4.879022121429443, 5.6017138957977295, 4.979279518127441, 4.966690301895142, 4.578589677810669, 4.932100296020508, 4.541912078857422, 4.492763519287109, 4.295711994171143, 3.9849767684936523, 3.870016574859619, 3.5410282611846924, 3.4597890377044678, 3.531838893890381, 3.4441349506378174, 3.857301712036133, 3.580857038497925, 4.239558696746826, 3.4955568313598633, 3.7223432064056396, 3.483037233352661, 3.6915016174316406, 5.080874681472778, 4.306368827819824, 4.166004180908203, 4.276215553283691, 3.8823728561401367, 4.108126640319824, 4.129433870315552, 4.017185211181641, 4.192007780075073, 4.500428676605225, 4.703749656677246, 4.210745334625244, 4.667487144470215, 4.851907968521118, 4.005861759185791, 4.254481554031372, 4.211245775222778, 4.151506423950195, 4.652880907058716, 4.284797191619873, 4.084187984466553, 4.190452814102173, 4.039573907852173]}
    };
    aux_createCactusPlot(evResults,evaluationPathBase)
    legend('Location','southeast')
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_ab_crown_comparison.tikz'],14)

    evResults = {
        "dynamic/1.000000e-02/evResult_cifar10_large_automatic";
        % ab CROWN
        {'ab CROWN (CPU)', [4.7344486713409424, 4.5142073631286621, 3.8626186847686768, 4.2459928989410400, 3.9924905300140381, 4.2328283786773682, 3.7480447292327881, 3.9000329971313477, 4.1520957946777344, 3.7435293197631836, 4.0891344547271729, 3.7545611858367920, 3.9767680168151855, 3.7697398662567139, 3.7049391269683838, 4.0941660404205322, 3.8685855865478516, 4.2266705036163330, 4.0941689014434814, 4.0062813758850098, 3.9459180831909180, 4.0079119205474854, 4.2990069389343262, 3.9996397495269775, 4.0430703163146973, 3.7824716567993164, 3.7302160263061523, 3.9121990203857422, 3.5921409130096436, 3.9444093704223633, 3.9015524387359619, 4.1468062400817871, 4.1140720844268799, 3.9891846179962158, 4.0160143375396729, 4.0310277938842773, 4.1667571067810059, 3.5919082164764404, 3.4492428302764893, 3.0960843563079834, 3.0668764114379883, 3.1108129024505615, 2.8864567279815674, 2.7252473831176758, 3.2412474155426025, 2.9668309688568115, 3.9780519008636475, 3.9567735195159912, 4.0089869499206543, 3.5439724922180176, 3.7761776447296143, 3.5258960723876953, 3.5278778076171875, 3.7299642562866211, 3.4843807220458984, 3.3987026214599609, 3.2464997768402100, 2.9362778663635254, 3.5726835727691650, 3.2984037399291992, 3.7666776180267334, 3.7123198509216309, 3.6138789653778076, 3.6127519607543945, 3.5655927658081055, 3.3032813072204590, 3.6500747203826904, 3.1865782737731934, 2.8334133625030518, 3.9169044494628906, 3.7760822772979736, 3.5872929096221924, 3.5855824947357178, 3.7161920070648193, 3.5580284595489502, 3.9937458038330078, 3.9392187595367432, 3.5607452392578125, 3.8149631023406982, 3.7040464878082275, 4.1759262084960938, 4.0521943569183350, 3.8002600669860840, 3.8050155639648438, 3.9607105255126953, 4.4061081409454346, 4.7636365890502930, 4.4434850215911865, 4.4178054332733154, 4.9334657192230225, 3.7700660228729248, 3.8917706012725830, 3.7830655574798584, 3.7470204830169678, 3.9219758510589600, 3.9358429908752441, 4.1027204990386963, 3.2769982814788818, 2.8783478736877441, 2.9390707015991211]}
    };
    aux_createCactusPlot(evResults,evaluationPathBase)   
    legend('Location','southeast')
    aux_matlab2tikz([evaluationPathBase 'cifar_marabou_large_comparison.tikz'],14)
    

    % Ashok comparison
    evResults = [
        "static/1.000000e-03/evResult_mnist_relu_6_500"
        "static/1.000000e-03/evResult_mnist_relu_6_200"
        "static/1.000000e-03/evResult_mnist_relu_6_100"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_ashok_comparison.tikz'],14)

    % ERAN benchmark
    evResults = [
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200"
        "static/1.000000e-03/evResult_mnist_relu_6_200"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_benchmark.tikz'],14)

    % mnist radius/tolerance sigmoid
    evResults = [
        "static/5.000000e-03/evResult_mnist_sigmoid_6_200_hugeTol"
        "static/5.000000e-03/evResult_mnist_sigmoid_6_200_largeTol"
        "static/5.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol5"
        "static/5.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol"
        "static/5.000000e-03/evResult_mnist_sigmoid_6_200_tinyTol"

        "static/2.000000e-03/evResult_mnist_sigmoid_6_200_hugeTol"
        "static/2.000000e-03/evResult_mnist_sigmoid_6_200_largeTol"
        "static/2.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol5"
        "static/2.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol"
        "static/2.000000e-03/evResult_mnist_sigmoid_6_200_tinyTol"

        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_hugeTol"
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_largeTol"
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol5"
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_mediumTol"
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_tinyTol"
    ];
    aux_createReductionVsVerification(evResults, evaluationPathBase);

  % mnist radius/tolerance relu
    evResults = [
        "static/5.000000e-03/evResult_mnist_relu_6_200_hugeTol"
        "static/5.000000e-03/evResult_mnist_relu_6_200_largeTol"
        "static/5.000000e-03/evResult_mnist_relu_6_200_mediumTol5"
        "static/5.000000e-03/evResult_mnist_relu_6_200_mediumTol"
        "static/5.000000e-03/evResult_mnist_relu_6_200_tinyTol"

        "static/2.000000e-03/evResult_mnist_relu_6_200_hugeTol"
        "static/2.000000e-03/evResult_mnist_relu_6_200_largeTol"
        "static/2.000000e-03/evResult_mnist_relu_6_200_mediumTol5"
        "static/2.000000e-03/evResult_mnist_relu_6_200_mediumTol"
        "static/2.000000e-03/evResult_mnist_relu_6_200_tinyTol"

        "static/1.000000e-03/evResult_mnist_relu_6_200_hugeTol"
        "static/1.000000e-03/evResult_mnist_relu_6_200_largeTol"
        "static/1.000000e-03/evResult_mnist_relu_6_200_mediumTol5"
        "static/1.000000e-03/evResult_mnist_relu_6_200_mediumTol"
        "static/1.000000e-03/evResult_mnist_relu_6_200_tinyTol"
    ];
    aux_createReductionVsVerification(evResults, evaluationPathBase);

   % time saving
    evResults = [
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.00";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.10";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.20";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.30";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.40";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.50";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.60";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.70";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.80";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_0.90";
        "static/1.000000e-03/evResult_mnist_sigmoid_6_200_automatic_1.00";
    ];

    [remNeurons,relTime_mean,relTime_std] = aux_computeRelTimeStd(evaluationPathBase,evResults);
    aux_create_figure("", "Reduction rate \rho", "Relative verification time")
    color = CORAcolor('CORA:next'); idxRev = length(remNeurons):-1:1;
    plot(polygon([remNeurons,remNeurons(idxRev)],[relTime_mean+relTime_std,relTime_mean(idxRev)-relTime_std(idxRev)]),1:2,'FaceColor',color,'FaceAlpha',0.2)
    plot(remNeurons,relTime_mean,'Color',color);
    ylim([0,1])
    xlim([0,1])
    title('ERAN Sigmoid')
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_time_saving.tikz'],14)

    evResults = [
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.00";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.10";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.20";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.30";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.40";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.50";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.60";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.70";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.80";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_0.90";
        "dynamic/1.000000e-02/evResult_convMedGSIGMOID__Point_automatic_1.00";
    ];

    [remNeurons,relTime_mean,relTime_std] = aux_computeRelTimeStd(evaluationPathBase,evResults);
    aux_create_figure("", "Reduction rate \rho", "Relative verification time")
    color = CORAcolor('CORA:next'); idxRev = length(remNeurons):-1:1;
    plot(polygon([remNeurons,remNeurons(idxRev)],[relTime_mean+relTime_std,relTime_mean(idxRev)-relTime_std(idxRev)]),1:2,'FaceColor',color,'FaceAlpha',0.2)
    plot(remNeurons,relTime_mean,'Color',color);
    ylim([0,1])
    xlim([0,1])
    title('ERAN CNN')
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_cnn_time_saving.tikz'],14)


    % ERAN CNN
    evResults = [
        "static/1.000000e-03/evResult_convMedGSIGMOID__Point"
        "dynamic/1.000000e-03/evResult_convMedGSIGMOID__Point"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_cnn_manual_dynamic.tikz'],8)

    evResults = [
        "dynamic/1.000000e-03/evResult_convMedGRELU__Point"
        "dynamic/1.000000e-03/evResult_convMedGSIGMOID__Point"
        "dynamic/1.000000e-03/evResult_convMedGTANH__Point"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_cnn.tikz'],8)

    % compression
    evResults = [
        "dynamic/1.000000e-03/evResult_convMedGSigmoid__Point_compress"
        "dynamic/1.000000e-03/evResult_convMedGSigmoid__Point_normalize"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'mnist_eran_cnn_compress.tikz'],12)


    % marabou
    evResults = [
        "dynamic/1.000000e-02/evResult_cifar10_large_automatic"
        "dynamic/1.000000e-02/evResult_cifar10_medium_automatic"
        "dynamic/1.000000e-02/evResult_cifar10_small_automatic"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'cifar_marabou.tikz'],10)

    % cifar2020
    evResults = [
        "dynamic/1.000000e-02/evResult_convBigRELU__PGD_automatic"
        "dynamic/1.000000e-03/evResult_convBigRELU__PGD_automatic"
    ];
    aux_createReductionPerLayerFigure(evResults, false, evaluationPathBase);
    aux_matlab2tikz([evaluationPathBase 'cifar_cifar2020.tikz'],14)

    return % -----------------------------------------------------------

    
end


function aux_createCactusPlot(evResults,evaluationPathBase)
    aux_create_figure([], 'Number of verified instances', 'Cumulative time [s]')

    for i=1:numel(evResults)
        evResult_i = evResults{i};

        if isstring(evResult_i)
            % CORA results
            evResult = load( ...
                sprintf("%s/%s.mat", ...
                evaluationPathBase, evResult_i ...
                )).evResult;

            t = evResult.table;
            times = min(t(t.redVerified,:).redTime,t(t.redVerified,:).orgTime);
            name = split(evResult_i,'_');
            name = name{end};
        else
            % (a,b)-CROWN results
            name = evResult_i{1};
            times = evResult_i{2};
        end

        times = reshape(times,1,[]);
        times = sort(times);

        % plot
        plot(1:numel(times),cumsum(times),'-o','DisplayName',name)
    end   
    
    set(gca, 'YScale', 'log')

end

function aux_createReductionPerLayerFigure(evResults, doOriginal, evaluationPathBase)
    
    try

    orgNeurons = [];
    redNeurons = [];
    redNeurons_std_lower = [];
    redNeurons_std_upper = [];

    legendEntries = [evResults.replace('evResult_','').replace("_", "\_")];
    if doOriginal
        legendEntries = ["Original"; legendEntries];
    end
    
    aux_create_figure( ...        
        "", ...
        "Number of input neurons of layer k", ...
        "Remaining neurons" ...
    );
    shift = 0;

    for i=1:length(evResults)
        evResult_i = load( ...
            sprintf("%s/%s.mat", ...
            evaluationPathBase, evResults(i) ...
            )).evResult;
        t = evResult_i.table;
        t = t(t.orgVerified & t.redVerified, :);

        orgNeurons_i = mean(t.orgNeurons);

        if doOriginal && i == 1
            redNeurons(end+1, shift+1:shift+length(orgNeurons_i)) = orgNeurons_i;
        end

        redNeurons_i = mean(t.redNeurons);
        redNeurons(end+1, shift+1:shift+length(redNeurons_i)) = redNeurons_i;
        redNeurons_std_lower(end+1, shift+1:shift+length(redNeurons_i)) = aux_std(t.redNeurons, t.redNeurons <= redNeurons_i);
        redNeurons_std_upper(end+1, shift+1:shift+length(redNeurons_i)) = aux_std(t.redNeurons, t.redNeurons >= redNeurons_i);

        if contains(evResults(i),'compress')
            shift = 2;
        end

        orgNeurons(end+1, shift+1:shift+length(orgNeurons_i)) = orgNeurons_i;
    end

    % only show on every other layer
    idx = 1:size(redNeurons,2);
    % get all equal layer (and always show first)
    idxSame = [false,all((redNeurons(:,1:end-1) == redNeurons(:,2:end)) | (redNeurons(:,2:end) == 0))];
    % keep all layers where something changes
    idx = idx(~idxSame);

    % updates matrices
    if ~isempty(orgNeurons)
        orgNeurons = orgNeurons(:,idx);
    end
    redNeurons = redNeurons(:,idx);
    redNeurons_std_lower = redNeurons_std_lower(:,idx);
    redNeurons_std_upper = redNeurons_std_upper(:,idx);

    if ~doOriginal
        horg = bar(orgNeurons', 'EdgeColor', 'none');
        alpha(horg, 0.2)
        set(gca,'ColorOrderIndex',1)
    else
        
        redNeurons_std_lower = [zeros(1,length(idx));redNeurons_std_lower];
        redNeurons_std_upper = [zeros(1,length(idx));redNeurons_std_upper];
    end
    hBar = bar(redNeurons');
    
    % add error bar
    drawnow;
    for k = 1:length(hBar)
        ctr(k,:) = hBar(k).XData + hBar(k).XOffset;   % Note:  XOffset+ Is An Undocumented Feature, This Selects The ;bar’ Centres
        ydt(k,:) = hBar(k).YData;                                     % Individual Bar Heights
    end
    errorbar(ctr, ydt, redNeurons_std_lower, redNeurons_std_upper, 'k', 'LineStyle','none');

    idx = idx - shift;

    legend(hBar, legendEntries)
    yLim = ylim;
    ylim([0,yLim(2)])
    xticks(1:length(idx));
    xticklabels(idx);

    catch ME
        disp(ME.message)
    end
end

function aux_create_figure(stitle, sxlabel, sylabel)
    figure; hold on;
    title(stitle)
    xlabel(sxlabel)
    ylabel(sylabel)
    % fontsize(gcf, 16, "points")
end


function aux_createReductionVsVerification(evResults, evaluationPathBase)

    radii = [];
    tols = [];
    reds = [];
    vers = [];

    for i=1:length(evResults)
        evResult_i = load( ...
            sprintf('%s/%s.mat', ...
            evaluationPathBase, ...
            evResults(i) ...
            )).evResult;

        radii = [radii, evResult_i.radius];
        tols = [tols, evResult_i.tol];

        t = evResult_i.table;
        vers = [vers, ...
           height(t(t.orgVerified & t.redVerified, :))/height(t(t.orgVerified, :))];

        % compute reduction rate
        redRate = rowfun( ...
            @(orgNeurons, redNeurons) sum(redNeurons(2:2:end-1))/sum(orgNeurons(2:2:end-1)), ...
            t(:, ["orgNeurons", "redNeurons"]), ...
            'OutputVariableNames', 'redRate');
        reds = [reds, mean(redRate.redRate)];
    end

    % show table
    disp("--------")
    disp(evResult_i.modelfile)
    disp(" ")

    fprintf("\\begin{tabular}{c c r r}\n" +...
         "\\toprule\n" + ...
        "$\\pertRadius$ & $\\bucketTol$ & $\\reductionRate$ & VR [\\%%] \\\\\n");
    A = [radii; tols; reds; vers * 100]';
    A = [num2str(A(:, 1:2), '%.4f & '), num2str(A(:, 3:4), '%.2f & ')];
    for i = 1:size(A, 1)
        if mod(i, 5) == 1
            disp("\midrule")
        end
        disp([A(i,1:end-2) ' \\'])
    end
    fprintf("\\bottomrule\n" + ...
        "\\end{tabular}\n")

    disp(" ")
end


function aux_matlab2tikz(filename,nrLayers)
    return % only for latex/tikz plots in evaluation
    drawnow
    matlab2tikz(filename,'showInfo', false)

    fid  = fopen(filename,'r');
    f=fread(fid,'*char')';
    fclose(fid);
    
    comp = compose('\\begin{tikzpicture}\n\n\\renewcommand{\\barwidth}{0.2cm}');
    f = strrep(f,'\begin{tikzpicture}',comp{1});
    f = regexprep(f,'width=[0-9]*.[0-9]*in','width=0.8\\linewidth');
    if nrLayers == 14
        f = regexprep(f,'\.777*8','.775');
        f = regexprep(f,'\.2222*','.225');
        f = regexprep(f,'\.857142857142(857|86|9)','.8875');
        f = regexprep(f,'\.1428571428571(4|)','.1125');
    elseif nrLayers == 10
        f = regexprep(f,'\.777*8','.83225');
        f = regexprep(f,'\.2222*','.16725');
    elseif nrLayers == 12
        f = regexprep(f,'\.857142857142(857|86|9)','.9');
        f = regexprep(f,'\.1428571428571(4|)','.1');
    elseif nrLayers == 8
        f = regexprep(f,'\.777*8','.8625');
        f = regexprep(f,'\.2222*','.1375');
        f = regexprep(f,'\.857142857142(857|86|9)','.93');
        f = regexprep(f,'\.1428571428571(4|)','.07');
    end
    f = regexprep(f,'height=[0-9]*.[0-9]*in','height=1.25in');
    f = regexprep(f,'at=\{\([0-9]*.[0-9]*in,[0-9]*.[0-9]*in\)\},','at={(0in,0in)},');
    f = strrep(f,'ybar,','ybar, draw=none,');
    f = regexprep(f,'bar width=[0-9]*.[0-9]*,', '');
    f = regexprep(f,'bar width=[0-9]*.[0-9]*,', '');
    f = strrep(f,', draw=black', '');
    f = strrep(f,'\addplot [color=black, only marks, forget plot]', '\addplot [color=black, no markers, mark size=\barwidth/4, draw=none, forget plot]');
    f = strrep(f,', error bar style={line width=0.5pt}, error mark options={line width=0.5pt, mark size=6.0pt, rotate=90}', '');
    f = strrep(f,'bar shift auto,', 'bar shift auto=0, bar width=\barwidth,');
    f = strrep(f,'fill opacity=0.2, ', 'bar shift=(0.5-T/2+(i-1))*\barwidth, fill opacity=0.2, forget plot, ');
    T = count(f, 'bar shift=(0.5-T/2+(i-1))');
    for i=1:T
        % correct bar positioning
        f = regexprep(f, 'bar shift=\(0.5-T/2\+\(i-1\)\)', sprintf('bar shift=(0.5-%d/2+(%d-1))', T, i), 'once');
    end

    fid  = fopen(filename,'w');
    fprintf(fid,'%s',f);
    fclose(fid);
    
end

function STD = aux_std(M,W)
    M_ = mean(M);
    STD = sqrt(1./(sum(W)-1) .* sum(((M-M_).*W).^2));
end

function [remNeurons,relTime_mean,relTime_std] = aux_computeRelTimeStd(evaluationPathBase,evResults)

    % init
    n = length(evResults)-1;
    remNeurons = (0:n)/10;
    relTime_mean = zeros(size(remNeurons));
    relTime_std = zeros(size(remNeurons));

    % iterate over all results
    for i=1:length(evResults)
        evResult = load( ...
            sprintf("%s/%s.mat", ...
            evaluationPathBase, evResults(i)) ...
            ).evResult;
        t = evResult.table;

        % compute reduction rate
        redRate = rowfun( ...
            @(orgNeurons, redNeurons) sum(redNeurons(2:2:end-1))/sum(orgNeurons(2:2:end-1)), ...
            t(:, ["orgNeurons", "redNeurons"]), ...
            'OutputVariableNames', 'redRate');
        try % in case redRate was already computed
            t = [t, redRate];
        end

        % save results
        relTime_mean(i) = mean(t.redTime ./ t.orgTime);
        relTime_std(i) = std(t.redTime ./ t.orgTime);
    end
end
