import math
import torch
import torch.nn as nn
import torch.nn.functional as F
import numpy as np


class CBLoss(nn.Module):

    def __init__(self, cls_num_list, args):
        super(CBLoss, self).__init__()
        beta = 0.9
        effective_num = 1.0 - np.power(beta, cls_num_list)
        per_cls_weights = (1.0 - beta) / np.array(effective_num)
        per_cls_weights = per_cls_weights / np.sum(per_cls_weights) * len(cls_num_list)
        per_cls_weights = torch.FloatTensor(per_cls_weights).cuda(args.gpu)

        self.weight = per_cls_weights

    def forward(self, x, target):
        return F.cross_entropy(x, target, weight=self.weight)
