# ProMO-LongTailedLearning
Official code for the paper "Long-Tailed Learning with Muon Optimizer"

## Environment Setup
### 1. Create and Activate Conda Environment
```bash
# Create environment (Python version can be adjusted as needed)
conda create -n muon-lt python=3.9 -y

# Activate environment
conda activate muon-lt
```

### 2. Install Dependencies (via YML File)
```bash
# The dependency file is environment.yml, run the following command
conda env update --file environment.yml --prune
export PATH=/root/anaconda3/envs/muonlt/bin:$PATH
```

## Quick Run
### 1. Prepare Datasets
Ensure the CIFAR-10/100 dataset is properly placed in the specified path or automatically downloaded to the default directory.

### 2. Run Experiments
```bash
# Grant execution permission (for first-time run)
chmod +x bash/*/*

# Run experiments

## run CIFAR-100 Balanced with BCL loss (Baseline)
bash bash/BCL/BCL_CIFAR_baseline.sh

## run CIFAR-100 LT under IF=100 with BCL loss and Muon optimizer
bash bash/BCL/BCL_CIFAR_muon.sh

## run CIFAR-100 LT under IF=100 with BCL loss and ProMO
bash bash/BCL/BCL_CIFAR_muon_mode.sh

## run CIFAR-100 Balanced with ProCo loss (Baseline)
bash bash/ProCo/ProCo_CIFAR_baseline.sh

## run CIFAR-100 LT under IF=100 with ProCo loss and Muon optimizer
bash bash/ProCo/ProCo_CIFAR_muon.sh

## run CIFAR-100 LT under IF=100 with ProCo loss and ProMO
bash bash/ProCo/ProCo_CIFAR_muon_mode.sh
```

### 3. Other Details
Experiment results (logs, model weights, etc.) will be saved to `./ouput` or `./mode`.

## License
Code released under the [Apache License 2.0](LICENSE).
