## Self-Supervised Learning with Spatiality Preserving Representation for EEG Signals

## Datasets 

1. **Simultaneous Task EEG Workload (STEW):**
   STEW dataset is available through IEEE DataPort.

   [Download STEW Dataset](https://dx.doi.org/10.21227/44r8-ya50)

2. **Temple University Datasets:**
   TUAB and TUEV are available through Temple University EEG Resources upon request.

   [Download Temple University Datasets](https://isip.piconepress.com/projects/nedc/html/tuh_eeg/index.shtml)

3. **The Children's Hospital Boston-MIT (CHB-MIT):**
   CHB-MIT is a publicly available dataset.

   [Download CHB-MIT Dataset](https://doi.org/10.13026/C2K01R)

## Preprocessing

We follow the BIOT preprocessing method for CHB-MIT, TUEV and TUAB datasets.

[Preprocessing code](https://github.com/ycq091044/BIOT/tree/main/datasets)

## Setup

_Instructions refer to Unix-based systems (e.g. Linux, MacOS)._

This code has been tested with `Python 3.12`.

`pip install -r requirements.txt`

## Run

To see all command options with explanations, run: `python main.py --help`
In `main.py` you can select the datasets and modify the model parameters.
For example:

`self.parser.add_argument('--epochs', type=int, default=100, help='Number of training epochs')`

or you can set the parameters:

`python main.py --epochs 100 --data_dir ../Dataset/STEW`