# InpExp

## Explainers

```
EXPLAINERS=(
    deep_lift
    feature_ablation
    gradcam
    gradient_shap
    guided_backprop
    guided_gradcam
    input_x_gradient
    integrated_gradients
    kernel_shap
    lime
    lrp
    occlusion
    saliency
)
```

## Top configs

### explainer.area=0.3



```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
guidance.scale.value=1.5 \
inpainter.subconfig.start_step=600 \
explainer.cell_size=4
```

### explainer.area=0.2

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
explainer.area=0.2 \
guidance.scale.value=1.5 \
inpainter.subconfig.start_step=600 \
explainer.cell_size=4
```

### explainer.area=0.1

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
explainer.area=0.1 \
guidance.scale.value=3.0 \
inpainter.subconfig.start_step=600 \
explainer.cell_size=4
```

NOTE: This configuration was the best when using a 20-30 checkpoint.

## Defaults

### explainer.area=0.3

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP
```

### explainer.area=0.2

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
explainer.area=0.2 \
guidance.scale.value=2.2
```

### explainer.area=0.1

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
explainer.area=0.1 \
guidance.scale.value=3.0 \
inpainter.subconfig.load=data/weights/inpainters/cddb/imagenet/freeform_10_20/latest.pt
```

### explainer.area=0.05

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
explainer.area=0.05 \
guidance.scale.value=3.0 \
inpainter.subconfig.load=data/weights/inpainters/cddb/imagenet/freeform_10_20/latest.pt
```

## Other inpainters

### RePaint

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide_repaint \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
guidance.stabilization.reset_step=2410
```

## LangSAM

Using LangSAM requires installing GroundingDino from source. In addition to creating our conda environment, run

```
cd ~
git clone https://github.com/IDEA-Research/GroundingDINO.git
cd GroundingDINO/
pip install -e .
```

To use LangSAM explainer, run

```
WANDB_MODE=offline HYDRA_FULL_ERROR=1 python src/main.py \
--config-name imagenet_cava_target_to_guide \
exp.target_id=$TARGET_ID \
exp.guide_id=$GUIDE_ID \
exp.batch_multip=$BATCH_MULTIP \
exp.n_inpaints=1 \
explainer=lang_sam \
explainer.get_attr_maps_kwargs.text_prompt=$TEXT_PROMPT \
explainer.get_attr_maps_kwargs.use_binary_masks=$USE_BINARY_MASKS
```

A100 allows for `exp.n_inpaints=1` only when moving LangSAM to GPU memory. Setting `USE_BINARY_MASKS=true` means that original binary masks provided by LangSAM are used. This ignores `explainer.area`, meaning that area is no longer controlled. To regain this control, you can use `USE_BINARY_MASKS=false`, which will choose pixels from the mask with highest logits from LangSAM if the original area is larger than `explainer.area`.