from omegaconf import DictConfig
from hydra.utils import instantiate
from pytorch_fid.fid_score import calculate_fid_given_paths
from utils.wandb_utils import download_run

import utils

import logging
log = logging.getLogger(__name__)

def run(config: DictConfig):
    assert config.exp.run_id is not None, "Please provide a run_id to calculate the metric"

    log.info("Connecting to wandb")
    project_name = f"{config.wandb.entity}/{config.wandb.project}"

    run_dir, _, _ = download_run(project_name, config.exp.run_id, area_threshold=config.exp.area_threshold)
    log.info(f"Run dir: {run_dir}")


    return 0